"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorDurationComponent = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _ml_integeration = require("../ml/ml_integeration");
var _charts = require("../../common/charts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This chart is intended to visualize monitor duration performance over time to
 * the users in a helpful way. Its x-axis is based on a timeseries, the y-axis is in
 * milliseconds.
 * @param props The props required for this component to render properly
 */
const MonitorDurationComponent = ({
  locationDurationLines,
  anomalies,
  loading,
  hasMLJob
}) => {
  var _anomalies$anomalies$, _anomalies$anomalies;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, hasMLJob ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.monitorCharts.monitorDuration.titleLabelWithAnomaly",
    defaultMessage: "Monitor duration (Anomalies: {noOfAnomalies})",
    values: {
      noOfAnomalies: (_anomalies$anomalies$ = anomalies === null || anomalies === void 0 ? void 0 : (_anomalies$anomalies = anomalies.anomalies) === null || _anomalies$anomalies === void 0 ? void 0 : _anomalies$anomalies.length) !== null && _anomalies$anomalies$ !== void 0 ? _anomalies$anomalies$ : 0
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.monitorCharts.monitorDuration.titleLabel",
    defaultMessage: "Monitor duration"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_ml_integeration.MLIntegrationComponent, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_charts.DurationChartComponent, {
    locationDurationLines: locationDurationLines,
    loading: loading,
    anomalies: anomalies
  }));
};
exports.MonitorDurationComponent = MonitorDurationComponent;