"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEditMonitorLocator = useEditMonitorLocator;
var _react = require("react");
var _common = require("@kbn/observability-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useEditMonitorLocator({
  configId,
  locators
}) {
  var _useKibana$services, _useKibana$services$s, _ref;
  const [editUrl, setEditUrl] = (0, _react.useState)(undefined);
  const syntheticsLocators = (_useKibana$services = (0, _public.useKibana)().services) === null || _useKibana$services === void 0 ? void 0 : (_useKibana$services$s = _useKibana$services.share) === null || _useKibana$services$s === void 0 ? void 0 : _useKibana$services$s.url.locators;
  const locator = (_ref = locators || syntheticsLocators) === null || _ref === void 0 ? void 0 : _ref.get(_common.syntheticsEditMonitorLocatorID);
  (0, _react.useEffect)(() => {
    async function generateUrl() {
      const url = await (locator === null || locator === void 0 ? void 0 : locator.getUrl({
        configId
      }));
      setEditUrl(url);
    }
    generateUrl();
  }, [locator, configId]);
  return editUrl;
}