"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GreenCheckIcon = exports.DonutChart = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _charts = require("@elastic/charts");
var _donut_chart_legend = require("./donut_chart_legend");
var _contexts = require("../../../contexts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GreenCheckIcon = exports.GreenCheckIcon = (0, _styledComponents.default)(_eui.EuiIcon)`
  height: 42px;
  width: 42px;
  color: #017d73;
  top: 51px;
  left: 51px;
  position: absolute;
`;
const themeOverrides = {
  chartMargins: {
    top: 0,
    bottom: 0,
    left: 0,
    right: 0
  },
  partition: {
    linkLabel: {
      maximumSection: Infinity
    },
    idealFontSizeJump: 1.1,
    outerSizeRatio: 0.9,
    emptySizeRatio: 0.4,
    circlePadding: 4
  }
};
const DonutChart = ({
  height,
  down,
  up
}) => {
  var _chartTheme$theme;
  const {
    colors: {
      danger,
      gray
    },
    chartTheme
  } = (0, _react.useContext)(_contexts.UptimeThemeContext);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      position: 'relative'
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: height,
    "aria-label": _i18n.i18n.translate('xpack.uptime.snapshot.donutChart.ariaLabel', {
      defaultMessage: 'Pie chart showing the current status. {down} of {total} monitors are down.',
      values: {
        down,
        total: up + down
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: [themeOverrides, (_chartTheme$theme = chartTheme.theme) !== null && _chartTheme$theme !== void 0 ? _chartTheme$theme : {}],
    baseTheme: chartTheme.baseTheme,
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.Partition, {
    id: "spec_1",
    data: [{
      value: down,
      label: 'Down'
    }, {
      value: up,
      label: 'Up'
    }],
    layout: _charts.PartitionLayout.sunburst,
    valueAccessor: d => d.value,
    layers: [{
      groupByRollup: d => d.label,
      nodeLabel: d => d,
      shape: {
        fillColor: dataName => {
          return dataName === 'Down' ? danger : gray;
        }
      }
    }]
  })), down === 0 && /*#__PURE__*/_react.default.createElement(GreenCheckIcon, {
    className: "greenCheckIcon",
    type: "checkInCircleFilled"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_donut_chart_legend.DonutChartLegend, {
    down: down,
    up: up
  })));
};
exports.DonutChart = DonutChart;