"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TLS_CERTIFICATE = exports.SYNTHETICS_TLS_RULE = exports.SYNTHETICS_STATUS_RULE = exports.SYNTHETICS_RULE_TYPES_ALERT_CONTEXT = exports.SYNTHETICS_ALERT_RULE_TYPES = exports.MONITOR_STATUS = exports.ACTION_GROUP_DEFINITIONS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MONITOR_STATUS = exports.MONITOR_STATUS = {
  id: 'xpack.synthetics.alerts.actionGroups.monitorStatus',
  name: _i18n.i18n.translate('xpack.uptime.alertRules.actionGroups.monitorStatus', {
    defaultMessage: 'Synthetics monitor status'
  })
};
const TLS_CERTIFICATE = exports.TLS_CERTIFICATE = {
  id: 'xpack.synthetics.alerts.actionGroups.tls',
  name: _i18n.i18n.translate('xpack.uptime.alertRules.actionGroups.tls', {
    defaultMessage: 'Synthetics TLS certificate'
  })
};
const ACTION_GROUP_DEFINITIONS = exports.ACTION_GROUP_DEFINITIONS = {
  MONITOR_STATUS,
  TLS_CERTIFICATE
};
const SYNTHETICS_STATUS_RULE = exports.SYNTHETICS_STATUS_RULE = 'xpack.synthetics.alerts.monitorStatus';
const SYNTHETICS_TLS_RULE = exports.SYNTHETICS_TLS_RULE = 'xpack.synthetics.alerts.tls';
const SYNTHETICS_ALERT_RULE_TYPES = exports.SYNTHETICS_ALERT_RULE_TYPES = {
  MONITOR_STATUS: SYNTHETICS_STATUS_RULE,
  TLS: SYNTHETICS_TLS_RULE
};
const SYNTHETICS_RULE_TYPES_ALERT_CONTEXT = exports.SYNTHETICS_RULE_TYPES_ALERT_CONTEXT = 'observability.uptime';