"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isFrozenDeprecation = exports.getCorrectiveAction = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isFrozenDeprecation = (message, indexName) => Boolean(indexName) && message.includes(`Index [${indexName}] is a frozen index`);
exports.isFrozenDeprecation = isFrozenDeprecation;
const getCorrectiveAction = deprecation => {
  var _metadata$actions, _metadata$actions2, _deprecation$metadata;
  const {
    index,
    type,
    message,
    metadata
  } = deprecation;
  const indexSettingDeprecation = metadata === null || metadata === void 0 ? void 0 : (_metadata$actions = metadata.actions) === null || _metadata$actions === void 0 ? void 0 : _metadata$actions.find(action => action.action_type === 'remove_settings' && index);
  const clusterSettingDeprecation = metadata === null || metadata === void 0 ? void 0 : (_metadata$actions2 = metadata.actions) === null || _metadata$actions2 === void 0 ? void 0 : _metadata$actions2.find(action => action.action_type === 'remove_settings' && typeof index === 'undefined');
  const requiresReindexAction = (type === 'index_settings' || type === 'node_settings') && ((_deprecation$metadata = deprecation.metadata) === null || _deprecation$metadata === void 0 ? void 0 : _deprecation$metadata.reindex_required) === true;
  const requiresUnfreezeAction = isFrozenDeprecation(message, index);
  const requiresIndexSettingsAction = Boolean(indexSettingDeprecation);
  const requiresClusterSettingsAction = Boolean(clusterSettingDeprecation);
  const requiresMlAction = /[Mm]odel snapshot/.test(message);
  const requiresDataStreamsAction = type === 'data_streams';
  if (requiresDataStreamsAction) {
    const {
      total_backing_indices: totalBackingIndices,
      indices_requiring_upgrade_count: indicesRequiringUpgradeCount = 0,
      indices_requiring_upgrade: indicesRequiringUpgrade = [],
      ignored_indices_requiring_upgrade: ignoredIndicesRequiringUpgrade = [],
      ignored_indices_requiring_upgrade_count: ignoredIndicesRequiringUpgradeCount = 0,
      reindex_required: reindexRequired
    } = metadata;

    /**
     * If there are no indices requiring upgrade, or reindexRequired = false.
     * Then we don't need to show the corrective action
     */
    if (indicesRequiringUpgradeCount < 1 || !reindexRequired) {
      return;
    }
    return {
      type: 'dataStream',
      metadata: {
        ignoredIndicesRequiringUpgrade,
        ignoredIndicesRequiringUpgradeCount,
        totalBackingIndices,
        indicesRequiringUpgradeCount,
        indicesRequiringUpgrade,
        reindexRequired
      }
    };
  }
  if (requiresReindexAction) {
    var _deprecation$metadata2;
    const transformIds = metadata === null || metadata === void 0 ? void 0 : metadata.transform_ids;
    return {
      type: 'reindex',
      ...(transformIds !== null && transformIds !== void 0 && transformIds.length ? {
        transformIds
      } : {}),
      metadata: {
        isClosedIndex: Boolean(deprecation.isClosedIndex),
        isFrozenIndex: Boolean(deprecation.isFrozenIndex),
        isInDataStream: Boolean((_deprecation$metadata2 = deprecation.metadata) === null || _deprecation$metadata2 === void 0 ? void 0 : _deprecation$metadata2.is_in_data_stream)
      }
    };
  }
  if (requiresUnfreezeAction) {
    var _deprecation$metadata3;
    return {
      type: 'unfreeze',
      metadata: {
        isClosedIndex: Boolean(deprecation.isClosedIndex),
        isFrozenIndex: Boolean(deprecation.isFrozenIndex),
        isInDataStream: Boolean((_deprecation$metadata3 = deprecation.metadata) === null || _deprecation$metadata3 === void 0 ? void 0 : _deprecation$metadata3.is_in_data_stream)
      }
    };
  }
  if (requiresIndexSettingsAction) {
    return {
      type: 'indexSetting',
      deprecatedSettings: indexSettingDeprecation.objects
    };
  }
  if (requiresClusterSettingsAction) {
    return {
      type: 'clusterSetting',
      deprecatedSettings: clusterSettingDeprecation.objects
    };
  }
  if (requiresMlAction) {
    const {
      snapshot_id: snapshotId,
      job_id: jobId
    } = metadata;
    return {
      type: 'mlSnapshot',
      snapshotId,
      jobId
    };
  }
};
exports.getCorrectiveAction = getCorrectiveAction;