"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrateSystemIndicesButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  inProgressButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.inProgressButtonLabel', {
    defaultMessage: 'Migration in progress'
  }),
  startButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.startButtonLabel', {
    defaultMessage: 'Migrate indices'
  }),
  modalTitle: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.confirmModal.title', {
    defaultMessage: 'Migrate Indices'
  }),
  modalButtonCancel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.confirmModal.cancelButton.label', {
    defaultMessage: 'Cancel'
  }),
  modalButtonConfirm: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.confirmModal.confirmButton.label', {
    defaultMessage: 'Confirm'
  }),
  modalButtonDescription: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.confirmModal.description', {
    defaultMessage: 'Migrating system indices may lead to downtime while they are reindexed.'
  })
};
const MigrateSystemIndicesButton = ({
  buttonProps,
  beginSystemIndicesMigration,
  isInitialRequest,
  isLoading,
  isMigrating
}) => {
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const isButtonDisabled = isInitialRequest && isLoading;
  const handleConfirmMigration = () => {
    beginSystemIndicesMigration();
    setIsModalVisible(false);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, buttonProps, {
    isLoading: isMigrating,
    isDisabled: isButtonDisabled,
    onClick: () => setIsModalVisible(true),
    "data-test-subj": "startSystemIndicesMigrationButton"
  }), isMigrating ? i18nTexts.inProgressButtonLabel : i18nTexts.startButtonLabel), isModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: i18nTexts.modalTitle,
    onCancel: () => setIsModalVisible(false),
    onConfirm: handleConfirmMigration,
    cancelButtonText: i18nTexts.modalButtonCancel,
    confirmButtonText: i18nTexts.modalButtonConfirm,
    defaultFocusedButton: "confirm",
    "data-test-subj": "migrationConfirmModal"
  }, i18nTexts.modalButtonDescription));
};
exports.MigrateSystemIndicesButton = MigrateSystemIndicesButton;