"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogsStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _shared_imports = require("../../../../shared_imports");
var _app_context = require("../../../app_context");
var _logs_checkpoint = require("../../../lib/logs_checkpoint");
var _es_deprecation_logs = require("../../es_deprecation_logs");
var _external_links = require("../../es_deprecation_logs/fix_deprecation_logs/external_links");
var _es_deprecation_logs_flyout = require("../../es_deprecation_logs/fix_deprecation_logs/es_deprecation_logs_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  logsStepTitle: _i18n.i18n.translate('xpack.upgradeAssistant.overview.logsStep.title', {
    defaultMessage: 'Address API deprecations'
  }),
  logsStepDescription: _i18n.i18n.translate('xpack.upgradeAssistant.overview.logsStep.description', {
    defaultMessage: `Review the Elasticsearch deprecation logs to ensure you're not using deprecated APIs.`
  }),
  viewDetailsButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.logsStep.viewDetailsButtonLabel', {
    defaultMessage: 'View details'
  }),
  enableLogsButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.logsStep.enableLogsButtonLabel', {
    defaultMessage: 'Enable logging'
  }),
  logsCountDescription: (deprecationCount, checkpoint) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.overview.logsStep.countDescription",
    defaultMessage: "You have {deprecationCount, plural, =0 {no} other {{deprecationCount}}} deprecation {deprecationCount, plural, one {issue} other {issues}} since {checkpoint}.",
    values: {
      deprecationCount,
      checkpoint: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
        value: checkpoint,
        year: "numeric",
        month: "long",
        day: "2-digit"
      }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedTime, {
        value: checkpoint,
        timeZoneName: "short",
        hour12: false
      }))
    }
  }),
  missingIndexPrivilegesTitle: _i18n.i18n.translate('xpack.upgradeAssistant.overview.logsStep.missingPrivilegesTitle', {
    defaultMessage: 'You require index privileges to analyze the deprecation logs'
  }),
  missingIndexPrivilegesDescription: privilegesMissing => {
    var _privilegesMissing$in;
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.overview.logsStep.missingPrivilegesDescription",
      defaultMessage: "The deprecation logs will continue to be indexed, but you won't be able to analyze them until you have the {requiredPrivileges} index privileges for: {missingPrivileges}",
      values: {
        requiredPrivileges: /*#__PURE__*/_react.default.createElement("i", null, _constants.APP_LOGS_COUNT_INDEX_PRIVILEGES.join(', ')),
        missingPrivileges: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          transparentBackground: true
        }, privilegesMissing === null || privilegesMissing === void 0 ? void 0 : (_privilegesMissing$in = privilegesMissing.index) === null || _privilegesMissing$in === void 0 ? void 0 : _privilegesMissing$in.join(', '))
      }
    });
  },
  missingClusterPrivilegesTitle: _i18n.i18n.translate('xpack.upgradeAssistant.overview.logsStep.missingClusterPrivilegesTitle', {
    defaultMessage: 'You require cluster privileges to analyze the deprecation logs'
  }),
  missingClusterPrivilegesDescription: privilegesMissing => {
    var _privilegesMissing$cl, _privilegesMissing$cl2;
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.overview.logsStep.missingClusterPrivilegesDescription",
      defaultMessage: "The deprecation logs will continue to be indexed, but you won't be able to analyze them until you have the cluster {privilegesCount, plural, one {privilege} other {privileges}} for: {missingPrivileges}",
      values: {
        missingPrivileges: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          transparentBackground: true
        }, privilegesMissing === null || privilegesMissing === void 0 ? void 0 : (_privilegesMissing$cl = privilegesMissing.cluster) === null || _privilegesMissing$cl === void 0 ? void 0 : _privilegesMissing$cl.join(', ')),
        privilegesCount: privilegesMissing === null || privilegesMissing === void 0 ? void 0 : (_privilegesMissing$cl2 = privilegesMissing.cluster) === null || _privilegesMissing$cl2 === void 0 ? void 0 : _privilegesMissing$cl2.length
      }
    });
  },
  loadingError: _i18n.i18n.translate('xpack.upgradeAssistant.overview.logsStep.loadingError', {
    defaultMessage: 'An error occurred while retrieving the deprecation log count'
  }),
  retryButton: _i18n.i18n.translate('xpack.upgradeAssistant.overview.logsStep.retryButton', {
    defaultMessage: 'Try again'
  })
};
const FLYOUT_ID = 'deprecationLogsFlyout';
const {
  useGlobalFlyout
} = _shared_imports.GlobalFlyout;
const LogStepDescription = () => /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.logsStepDescription));
const LogsStep = ({
  setIsComplete,
  hasPrivileges,
  privilegesMissing
}) => {
  const {
    services: {
      api
    }
  } = (0, _app_context.useAppContext)();
  const {
    isDeprecationLogIndexingEnabled,
    resendRequest: refreshDeprecationLogging
  } = (0, _es_deprecation_logs.useDeprecationLogging)();
  const checkpoint = (0, _logs_checkpoint.loadLogsCheckpoint)();
  const {
    data: logsCount,
    error,
    isLoading,
    resendRequest,
    isInitialRequest
  } = api.getDeprecationLogsCount(checkpoint);
  (0, _react.useEffect)(() => {
    if (!isDeprecationLogIndexingEnabled) {
      setIsComplete(false);
    }
    setIsComplete((logsCount === null || logsCount === void 0 ? void 0 : logsCount.count) === 0);

    // Depending upon setIsComplete would create an infinite loop.
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isDeprecationLogIndexingEnabled, logsCount]);
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const {
    addContent: addContentToGlobalFlyout,
    removeContent: removeContentFromGlobalFlyout
  } = useGlobalFlyout();
  const closeFlyout = (0, _react.useCallback)(() => {
    setShowFlyout(false);
    removeContentFromGlobalFlyout(FLYOUT_ID);
  }, [removeContentFromGlobalFlyout]);
  const handleToggleChange = (0, _react.useCallback)(() => {
    refreshDeprecationLogging();
  }, [refreshDeprecationLogging]);
  (0, _react.useEffect)(() => {
    if (showFlyout) {
      addContentToGlobalFlyout({
        id: FLYOUT_ID,
        Component: _es_deprecation_logs_flyout.EsDeprecationLogsFlyout,
        props: {
          closeFlyout,
          handleToggleChange
        },
        flyoutProps: {
          onClose: closeFlyout,
          'data-test-subj': 'esDeprecationLogsFlyout',
          'aria-labelledby': 'esDeprecationLogsFlyoutTitle'
        }
      });
    }
  }, [addContentToGlobalFlyout, closeFlyout, handleToggleChange, showFlyout]);
  if (hasPrivileges === false && isDeprecationLogIndexingEnabled) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(LogStepDescription, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), privilegesMissing.cluster && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "question",
      color: "warning",
      title: i18nTexts.missingClusterPrivilegesTitle,
      "data-test-subj": "missingClusterPrivilegesCallout"
    }, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.missingClusterPrivilegesDescription(privilegesMissing))), privilegesMissing.cluster && privilegesMissing.index && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), privilegesMissing.index && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "question",
      color: "warning",
      title: i18nTexts.missingIndexPrivilegesTitle,
      "data-test-subj": "missingIndexPrivilegesCallout"
    }, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.missingIndexPrivilegesDescription(privilegesMissing))));
  }
  if (isLoading && isInitialRequest) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 3
    });
  }
  if (hasPrivileges && error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: i18nTexts.loadingError,
      color: "danger",
      iconType: "warning",
      "data-test-subj": "deprecationLogsErrorCallout"
    }, /*#__PURE__*/_react.default.createElement("p", null, error.statusCode, " - ", error.message), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "danger",
      onClick: resendRequest,
      "data-test-subj": "deprecationLogsRetryButton"
    }, i18nTexts.retryButton));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(LogStepDescription, null), isDeprecationLogIndexingEnabled && logsCount ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "logsCountDescription"
  }, i18nTexts.logsCountDescription(logsCount.count, checkpoint))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: true,
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_external_links.DiscoverExternalLinks, {
    checkpoint: checkpoint,
    showInfoParagraph: false,
    isButtonFormat: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => setShowFlyout(true),
    "data-test-subj": "viewDetailsLink"
  }, i18nTexts.viewDetailsButtonLabel))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => setShowFlyout(true),
    "data-test-subj": "enableLogsLink"
  }, i18nTexts.enableLogsButtonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
const getLogsStep = ({
  isComplete,
  setIsComplete
}) => {
  const status = isComplete ? 'complete' : 'incomplete';
  const requiredPrivileges = [`index.${_constants.DEPRECATION_LOGS_INDEX}`, ..._constants.APP_LOGS_COUNT_CLUSTER_PRIVILEGES.map(privilege => `cluster.${privilege}`)];
  return {
    status,
    title: i18nTexts.logsStepTitle,
    'data-test-subj': `logsStep-${status}`,
    children: /*#__PURE__*/_react.default.createElement(_shared_imports.WithPrivileges, {
      privileges: requiredPrivileges
    }, ({
      hasPrivileges,
      isLoading,
      privilegesMissing
    }) => /*#__PURE__*/_react.default.createElement(LogsStep, {
      setIsComplete: setIsComplete,
      hasPrivileges: !isLoading && hasPrivileges,
      privilegesMissing: privilegesMissing
    }))
  };
};
exports.getLogsStep = getLogsStep;