"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBackupStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _on_prem_backup = require("./on_prem_backup");
var _cloud_backup = require("./cloud_backup");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const title = _i18n.i18n.translate('xpack.upgradeAssistant.overview.backupStepTitle', {
  defaultMessage: 'Back up your data'
});
const BackupStep = ({
  cloud,
  setIsComplete
}) => {
  const [forceOnPremStep, setForceOnPremStep] = (0, _react.useState)(false);
  if (cloud !== null && cloud !== void 0 && cloud.isCloudEnabled && !forceOnPremStep) {
    return /*#__PURE__*/_react.default.createElement(_cloud_backup.CloudBackup, {
      setIsComplete: setIsComplete,
      cloudSnapshotsUrl: cloud.snapshotsUrl,
      setForceOnPremStep: setForceOnPremStep
    });
  }
  return /*#__PURE__*/_react.default.createElement(_on_prem_backup.OnPremBackup, null);
};
const getBackupStep = ({
  cloud,
  isComplete,
  setIsComplete
}) => {
  const status = cloud !== null && cloud !== void 0 && cloud.isCloudEnabled ? isComplete ? 'complete' : 'incomplete' : 'incomplete';
  return {
    title,
    status,
    'data-test-subj': `backupStep-${status}`,
    children: /*#__PURE__*/_react.default.createElement(BackupStep, {
      cloud: cloud,
      setIsComplete: setIsComplete
    })
  };
};
exports.getBackupStep = getBackupStep;