"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateIndex = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUpdateIndex = ({
  indexName,
  api
}) => {
  const [failedState, setFailedState] = (0, _react.useState)(false);
  const [updateIndexState, setUpdateIndexState] = (0, _react.useState)({
    failedBefore: false,
    status: 'incomplete'
  });
  const updateIndex = (0, _react.useCallback)(async action => {
    const operations = action === 'unfreeze' ? ['unfreeze'] : ['blockWrite', 'unfreeze'];
    setUpdateIndexState({
      status: 'inProgress',
      failedBefore: failedState,
      updateAction: action
    });
    const res = action === 'delete' ? await api.deleteIndex(indexName) : await api.updateIndex(indexName, operations);
    const status = res.error ? 'failed' : 'complete';
    const failedBefore = failedState || status === 'failed';
    setFailedState(failedBefore);
    setUpdateIndexState({
      status,
      failedBefore,
      ...(res.error && {
        reason: res.error.message.toString()
      }),
      updateAction: action
    });
  }, [api, failedState, indexName]);
  return {
    updateIndexState,
    updateIndex
  };
};
exports.useUpdateIndex = useUpdateIndex;