"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexSettingsActionsCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  resolutionText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indexSettings.resolutionText', {
    defaultMessage: 'Remove settings'
  }),
  resolutionTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indexSettings.resolutionTooltipLabel', {
    defaultMessage: 'Resolve this issue by removing settings from this index. This issue can be resolved automatically.'
  })
};
const IndexSettingsActionsCell = ({
  openFlyout
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: i18nTexts.resolutionTooltipLabel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: openFlyout,
    "data-test-subj": 'deprecation-indexSetting'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    "data-test-subj": "indexSettingsActionsCell"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "indexSettings"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, i18nTexts.resolutionText)))));
};
exports.IndexSettingsActionsCell = IndexSettingsActionsCell;