"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultTableRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../shared_imports");
var _es_deprecations_table_cells = require("../../es_deprecations_table_cells");
var _flyout = require("./flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  useGlobalFlyout
} = _shared_imports.GlobalFlyout;
const DefaultTableRow = ({
  rowFieldNames,
  deprecation,
  index
}) => {
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const {
    addContent: addContentToGlobalFlyout,
    removeContent: removeContentFromGlobalFlyout
  } = useGlobalFlyout();
  const closeFlyout = (0, _react.useCallback)(() => {
    setShowFlyout(false);
    removeContentFromGlobalFlyout('deprecationDetails');
  }, [removeContentFromGlobalFlyout]);
  (0, _react.useEffect)(() => {
    if (showFlyout) {
      addContentToGlobalFlyout({
        id: 'deprecationDetails',
        Component: _flyout.DefaultDeprecationFlyout,
        props: {
          deprecation,
          closeFlyout
        },
        flyoutProps: {
          onClose: closeFlyout,
          className: 'eui-textBreakWord',
          'data-test-subj': 'defaultDeprecationDetails',
          'aria-labelledby': 'defaultDeprecationDetailsFlyoutTitle'
        }
      });
    }
  }, [addContentToGlobalFlyout, closeFlyout, deprecation, showFlyout]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    "data-test-subj": "deprecationTableRow",
    key: `deprecation-row-${index}`
  }, rowFieldNames.map(field => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      key: field,
      truncateText: false,
      "data-test-subj": `defaultTableCell-${field}`,
      align: field === 'actions' ? 'right' : 'left'
    }, /*#__PURE__*/_react.default.createElement(_es_deprecations_table_cells.EsDeprecationsTableCells, {
      fieldName: field,
      deprecation: deprecation,
      actionsTableCell: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => setShowFlyout(true),
        "data-test-subj": "deprecation-default"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "gear"
      }))
    }));
  }));
};
exports.DefaultTableRow = DefaultTableRow;