"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultDeprecationFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared = require("../../../shared");
var _constants = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  getFlyoutDescription: indexName => _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.deprecationDetailsFlyout.secondaryDescription', {
    defaultMessage: 'Index: {indexName}',
    values: {
      indexName
    }
  }),
  closeButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.deprecationDetailsFlyout.closeButtonLabel', {
    defaultMessage: 'Close'
  })
};
const DefaultDeprecationFlyout = ({
  deprecation,
  closeFlyout
}) => {
  const {
    message,
    url,
    details,
    index
  } = deprecation;
  const typeName = _constants.DEPRECATION_TYPE_MAP[deprecation.type];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_shared.DeprecationBadge, {
    level: deprecation.level,
    isResolved: false
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "defaultDeprecationDetailsFlyoutTitle"
  }, message)), index && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "flyoutDescription"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, typeName ? `${typeName}: ${index}` : i18nTexts.getFlyoutDescription(index))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", {
    className: "eui-textBreakWord"
  }, details), url && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_shared.DeprecationFlyoutLearnMoreLink, {
    documentationUrl: url
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeFlyout,
    flush: "left"
  }, i18nTexts.closeButtonLabel)))));
};
exports.DefaultDeprecationFlyout = DefaultDeprecationFlyout;