"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMigrationStep = useMigrationStep;
var _react = require("react");
var _data_stream_types = require("../../../../../../common/data_stream_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useMigrationStep(status, loadDataStreamMetadata, modalType) {
  const [step, setStep] = (0, _react.useState)('initializing');
  (0, _react.useEffect)(() => {
    if (step !== 'initializing') return;
    (async () => {
      await loadDataStreamMetadata();
    })();
  }, [step, loadDataStreamMetadata]);
  (0, _react.useEffect)(() => {
    if (status === _data_stream_types.DataStreamMigrationStatus.completed) {
      const timeoutId = setTimeout(() => setStep('completed'), 1500);
      return () => clearTimeout(timeoutId);
    }
    if (status === _data_stream_types.DataStreamMigrationStatus.notStarted) {
      if (modalType && modalType === 'delete') {
        setStep('confirmDelete');
      } else {
        setStep('confirm');
      }
    } else if ([_data_stream_types.DataStreamMigrationStatus.failed, _data_stream_types.DataStreamMigrationStatus.fetchFailed, _data_stream_types.DataStreamMigrationStatus.cancelled, _data_stream_types.DataStreamMigrationStatus.inProgress].includes(status)) {
      setStep('inProgress');
    }
  }, [status, modalType]);
  return [step, setStep];
}