"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.idForWarning = exports.ConfirmMigrationReadonlyFlyoutStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _app_context = require("../../../../../../../app_context");
var _warnings = require("./warnings");
var _callouts = require("./callouts");
var _warnings_callout = require("./warnings/warnings_callout");
var _nodes_low_disk_space = require("../../../../../common/nodes_low_disk_space");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const warningToComponentMap = {
  incompatibleDataStream: _warnings.IncompatibleDataInDataStreamWarningCheckbox,
  affectExistingSetups: _warnings.AffectExistingSetupsWarningCheckbox
};
const idForWarning = id => `migrationWarning-${id}`;

/**
 * Displays warning text about changes required to migrate this data stream. The user
 * must acknowledge each change before being allowed to proceed.
 */
exports.idForWarning = idForWarning;
const ConfirmMigrationReadonlyFlyoutStep = ({
  closeModal,
  warnings,
  startAction,
  meta,
  lastIndexCreationDateFormatted
}) => {
  const {
    services: {
      api,
      core: {
        docLinks
      }
    }
  } = (0, _app_context.useAppContext)();
  const {
    links
  } = docLinks;
  const [checkedIds, setCheckedIds] = (0, _react.useState)(warnings.reduce((initialCheckedIds, warning, index) => {
    initialCheckedIds[idForWarning(index)] = false;
    return initialCheckedIds;
  }, {}));
  const {
    data: nodes
  } = api.useLoadNodeDiskSpace();
  // Do not allow to proceed until all checkboxes are checked.
  const blockAdvance = Object.values(checkedIds).filter(v => v).length < warnings.length;
  const onChange = e => {
    const optionId = e.target.id;
    setCheckedIds(prev => ({
      ...prev,
      ...{
        [optionId]: !checkedIds[optionId]
      }
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    "data-test-subj": "dataStreamModalTitle",
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.modal.confirmStep.readonly.title",
    defaultMessage: "Set data stream to read-only"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_warnings_callout.DurationClarificationCallOut, {
    formattedDate: lastIndexCreationDateFormatted,
    learnMoreUrl: meta.documentationUrl
  }), nodes && nodes.length > 0 && /*#__PURE__*/_react.default.createElement(_nodes_low_disk_space.NodesLowSpaceCallOut, {
    nodes: nodes
  }), warnings.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_callouts.ReadonlyWarningCallout, null), warnings.map((warning, index) => {
    const WarningCheckbox = warningToComponentMap[warning.warningType];
    return /*#__PURE__*/_react.default.createElement(WarningCheckbox, {
      key: idForWarning(index),
      isChecked: checkedIds[idForWarning(index)],
      onChange: onChange,
      docLinks: links,
      id: idForWarning(index)
      // @ts-ignore
      ,
      meta: {
        ...meta,
        ...warning.meta
      }
    });
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal,
    "data-test-subj": "cancelDataStreamMigrationModal"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.modal.confirmStep.cancelReadOnlyButtonLabel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "primary",
    onClick: startAction,
    disabled: blockAdvance,
    "data-test-subj": "startActionButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.modal.checklistStep.startSetReadOnlyButtonLabel",
    defaultMessage: "Set all to read-only"
  }))))));
};
exports.ConfirmMigrationReadonlyFlyoutStep = ConfirmMigrationReadonlyFlyoutStep;