"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteExecute = deleteExecute;
var _types = require("../../../../../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function* deleteExecute(dataStreamName, api) {
  const startTimeMs = +Date.now();
  try {
    yield {
      migrationOp: {
        resolutionType: 'delete',
        status: _types.DataStreamMigrationStatus.inProgress,
        taskPercComplete: 1,
        progressDetails: {
          startTimeMs,
          successCount: 0,
          pendingCount: 1,
          inProgressCount: 0,
          errorsCount: 0
        }
      }
    };
    const {
      error
    } = await api.deleteDataStream(dataStreamName);
    if (error) {
      throw error;
    }
    return {
      migrationOp: {
        resolutionType: 'delete',
        status: _types.DataStreamMigrationStatus.completed,
        taskPercComplete: 1,
        progressDetails: {
          startTimeMs,
          successCount: 1,
          pendingCount: 0,
          inProgressCount: 0,
          errorsCount: 0
        }
      }
    };
  } catch (error) {
    return {
      migrationOp: {
        resolutionType: 'delete',
        status: _types.DataStreamMigrationStatus.failed,
        errorMessage: error.message || 'Unknown error occurred'
      }
    };
  }
}