"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteModal = ({
  closeModal,
  targetName,
  deleteIndex,
  type
}) => {
  const i18nTexts = {
    index: {
      deleteTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.esDeprecations.indices.deleteModal.index.titleLabel",
        defaultMessage: "Delete index"
      }),
      calloutTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.esDeprecations.indices.deleteModal.index.calloutTitle",
        defaultMessage: "Deleting index cannot be reversed"
      }),
      calloutText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.esDeprecations.indices.deleteModal.calloutText",
        defaultMessage: "You are about to delete index {targetName}. This is an irreversible action, and the data cannot be recovered from a deleted index. Make sure you have appropriate backups.",
        values: {
          targetName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, targetName)
        }
      }),
      deleteButtonLabel: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.esDeprecations.indices.deleteModal.index.deleteButtonLabel",
        defaultMessage: "Delete index"
      })
    },
    dataStream: {
      deleteTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.esDeprecations.dataStreams.deleteModal.dataStream.titleLabel",
        defaultMessage: "Delete data stream"
      }),
      calloutTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.esDeprecations.dataStreams.deleteModal.dataStream.calloutTitle",
        defaultMessage: "Deleting data stream cannot be reversed"
      }),
      calloutText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.esDeprecations.dataStreams.deleteModal.dataStream.calloutText1",
        defaultMessage: "You are about to delete data stream {targetName}. This is an irreversible action, and the data cannot be recovered from a deleted data stream. Make sure you have appropriate backups.",
        values: {
          targetName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, targetName)
        }
      })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.esDeprecations.dataStreams.deleteModal.dataStream.calloutText2",
        defaultMessage: "Data streams are collections of time series indices. Deleting a data stream will also delete its indices."
      }))),
      deleteButtonLabel: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.esDeprecations.dataStreams.deleteModal.dataStream.deleteButtonLabel",
        defaultMessage: "Delete data stream"
      })
    }
  };
  const [inputValue, setInputValue] = (0, _react.useState)('');
  const onChange = e => {
    setInputValue(e.target.value);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    "data-test-subj": type === 'index' ? 'updateIndexModalTitle' : 'dataStreamModalTitle',
    size: "m"
  }, i18nTexts[type].deleteTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18nTexts[type].calloutTitle,
    color: "warning",
    iconType: "warning"
  }, i18nTexts[type].calloutText), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Type the word 'delete' to confirm",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "delete",
    value: inputValue,
    onChange: onChange,
    fullWidth: true,
    "data-test-subj": "deleteIndexInput"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => {
      setInputValue('');
      closeModal();
    },
    color: "primary",
    "data-test-subj": "closeUpdateStepButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.deleteModal.closeButtonLabel",
    defaultMessage: "Close"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: () => {
      setInputValue('');
      deleteIndex();
    },
    disabled: inputValue.toLowerCase() !== 'delete',
    "data-test-subj": "startDeleteButton",
    color: "danger"
  }, i18nTexts[type].deleteButtonLabel))));
};
exports.DeleteModal = DeleteModal;