"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.strings = exports.QueryBarMenu = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _query_bar_menu_panels = require("./query_bar_menu_panels");
var _filter_editor_wrapper = require("./filter_editor_wrapper");
var _filter_editor = require("../filter_bar/filter_editor");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const strings = exports.strings = {
  getFilterSetButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.filterSetButtonLabel', {
    defaultMessage: 'Query menu'
  }),
  getSavedQueryPopoverSaveChangesButtonText: () => _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryPopoverSaveChangesButtonText', {
    defaultMessage: 'Update query'
  })
};
function QueryBarMenuComponent({
  language,
  nonKqlMode,
  disableQueryLanguageSwitcher,
  dateRangeFrom,
  dateRangeTo,
  timeFilter,
  onQueryChange,
  onQueryBarSubmit,
  savedQueryService,
  saveAsNewQueryFormComponent,
  saveFormComponent,
  manageFilterSetComponent,
  hiddenPanelOptions,
  openQueryBarMenu,
  toggleFilterBarMenuPopover,
  onFiltersUpdated,
  filters,
  additionalQueryBarMenuItems,
  query,
  savedQuery,
  onClearSavedQuery,
  showQueryInput,
  showFilterBar,
  showSaveQuery,
  showSavedQueryControls,
  indexPatterns,
  timeRangeForSuggestionsOverride,
  filtersForSuggestions,
  buttonProps,
  isDisabled,
  onCloseFilterPopover,
  onLocalFilterCreate,
  onLocalFilterUpdate,
  suggestionsAbstraction,
  queryBarMenuRef
}) {
  const [renderedComponent, setRenderedComponent] = (0, _react.useState)('menu');
  const [currentPanelId, setCurrentPanelId] = (0, _react.useState)(_query_bar_menu_panels.QueryBarMenuPanel.main);
  (0, _react.useEffect)(() => {
    if (openQueryBarMenu) {
      setCurrentPanelId(_query_bar_menu_panels.QueryBarMenuPanel.main);
      setRenderedComponent('menu');
    }
  }, [openQueryBarMenu]);
  const plainClosePopover = (0, _react.useCallback)(() => toggleFilterBarMenuPopover(false), [toggleFilterBarMenuPopover]);
  const closePopover = (0, _react.useCallback)(() => {
    onCloseFilterPopover([plainClosePopover]);
  }, [onCloseFilterPopover, plainClosePopover]);
  const normalContextMenuPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'normalContextMenuPopover'
  });
  const onButtonClick = () => {
    toggleFilterBarMenuPopover(!openQueryBarMenu);
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "long",
    content: strings.getFilterSetButtonLabel(),
    disableScreenReaderOutput: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    size: "m",
    display: "empty",
    onClick: onButtonClick,
    isDisabled: isDisabled
  }, buttonProps, {
    css: {
      borderTopRightRadius: 0,
      borderBottomRightRadius: 0
    },
    iconType: "filter",
    "aria-label": strings.getFilterSetButtonLabel(),
    "data-test-subj": "showQueryBarMenu"
  })));
  const panels = (0, _query_bar_menu_panels.useQueryBarMenuPanels)({
    filters,
    additionalQueryBarMenuItems,
    savedQuery,
    language,
    dateRangeFrom,
    dateRangeTo,
    timeFilter,
    query,
    showSaveQuery,
    showSavedQueryControls,
    showFilterBar,
    showQueryInput,
    savedQueryService,
    saveFormComponent,
    saveAsNewQueryFormComponent,
    manageFilterSetComponent,
    hiddenPanelOptions,
    nonKqlMode,
    disableQueryLanguageSwitcher,
    queryBarMenuRef,
    closePopover: plainClosePopover,
    onQueryBarSubmit,
    onFiltersUpdated,
    onClearSavedQuery,
    onQueryChange,
    setRenderedComponent
  });
  const renderComponent = () => {
    switch (renderedComponent) {
      case 'menu':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu
        // @ts-expect-error EuiContextMenu ref is mistyped
        , {
          ref: queryBarMenuRef,
          initialPanelId: _query_bar_menu_panels.QueryBarMenuPanel.main,
          panels: panels,
          onPanelChange: ({
            panelId
          }) => setCurrentPanelId(panelId),
          "data-test-subj": "queryBarMenuPanel",
          css: [{
            // Add width to transition properties to smooth
            // the animation when the panel width changes
            transitionProperty: 'width, height !important',
            // Add a white background to panels since panels
            // of different widths can overlap each other
            // when transitioning, but the background colour
            // ensures the incoming panel always overlays
            // the outgoing panel which improves the effect
            '.euiContextMenuPanel': {
              backgroundColor: _uiTheme.euiThemeVars.euiColorEmptyShade
            }
          },
          // Fix the update button underline on hover, and
          // the button focus outline being cut off
          currentPanelId === _query_bar_menu_panels.QueryBarMenuPanel.main && {
            '.euiContextMenuPanel__title': {
              ':hover': {
                textDecoration: 'none !important'
              },
              '.euiContextMenuItem__text': {
                overflow: 'visible'
              }
            }
          }]
        });
      case 'addFilter':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
          items: [/*#__PURE__*/_react.default.createElement(_filter_editor_wrapper.FilterEditorWrapper, {
            key: "filter-editor-wrapper",
            indexPatterns: indexPatterns,
            filters: filters,
            timeRangeForSuggestionsOverride: timeRangeForSuggestionsOverride,
            filtersForSuggestions: filtersForSuggestions,
            onFiltersUpdated: onFiltersUpdated,
            onLocalFilterUpdate: onLocalFilterUpdate,
            onLocalFilterCreate: onLocalFilterCreate,
            closePopoverOnAdd: plainClosePopover,
            closePopoverOnCancel: plainClosePopover,
            suggestionsAbstraction: suggestionsAbstraction
          })]
        });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: normalContextMenuPopoverId,
    button: button,
    isOpen: openQueryBarMenu,
    closePopover: renderedComponent === 'addFilter' ? closePopover : plainClosePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    repositionOnScroll: true,
    "data-test-subj": "queryBarMenuPopover"
  }, renderComponent());
}
const QueryBarMenu = exports.QueryBarMenu = (0, _filter_editor.withCloseFilterEditorConfirmModal)(QueryBarMenuComponent);