"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MinimisedFilterItemActions = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _action_strings = require("./action_strings");
var _actions = require("./actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const MinimisedFilterItemActions = props => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onMoreActionsButtonClick = () => {
    setIsPopoverOpen(isOpen => !isOpen);
  };
  const closePopover = () => setIsPopoverOpen(false);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "boxesHorizontal",
    color: "text",
    "aria-label": _action_strings.strings.getMoreActionsLabel(),
    onClick: onMoreActionsButtonClick
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: false,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(_actions.FilterItemActions, (0, _extends2.default)({}, props, {
    minimizePaddings: true
  })));
};
exports.MinimisedFilterItemActions = MinimisedFilterItemActions;