"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterItemActions = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _tooltip = require("../tooltip");
var _action_strings = require("./action_strings");
var _filter_item = require("../filter_item.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const FilterItemActions = ({
  disabled = false,
  disableRemove = false,
  hideOr = false,
  disableOr = false,
  hideAnd = false,
  disableAnd = false,
  minimizePaddings = false,
  onRemoveFilter,
  onOrButtonClick,
  onAddButtonClick
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const actionButtonClassName = (0, _filter_item.actionButtonCss)(euiTheme);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "flexEnd",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_tooltip.Tooltip, {
    content: _action_strings.strings.getDeleteButtonDisabled(),
    show: disableRemove || disabled
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: onRemoveFilter,
    iconType: "trash",
    isDisabled: disableRemove || disabled,
    size: "xs",
    color: "danger",
    "aria-label": _action_strings.strings.getDeleteFilterGroupButtonIconLabel()
    // EuiButtonIcon has no padding to minimize
  }))), !hideOr && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onOrButtonClick,
    isDisabled: disableOr || disabled,
    iconType: "plusInCircle",
    size: "xs",
    iconSize: "s",
    flush: "right",
    "aria-label": _action_strings.strings.getAddOrFilterGroupButtonIconLabel(),
    "data-test-subj": "add-or-filter",
    className: minimizePaddings ? actionButtonClassName : ''
  }, _action_strings.strings.getAddOrFilterGroupButtonLabel())), !hideAnd && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onAddButtonClick,
    isDisabled: disableAnd || disabled,
    iconType: "plusInCircle",
    size: "xs",
    iconSize: "s",
    flush: "right",
    "aria-label": _action_strings.strings.getAddAndFilterGroupButtonIconLabel(),
    "data-test-subj": "add-and-filter",
    className: minimizePaddings ? actionButtonClassName : ''
  }, _action_strings.strings.getAddAndFilterGroupButtonLabel())));
};
exports.FilterItemActions = FilterItemActions;