"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterButtonGroup = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
require("./filter_button_group.scss");
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const FilterButtonGroup = ({
  items,
  attached,
  size = 'm',
  ...rest
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, (0, _extends2.default)({
    className: (0, _classnames.default)('kbnFilterButtonGroup', {
      'kbnFilterButtonGroup--attached': attached,
      [`kbnFilterButtonGroup--${size}`]: size
    }),
    gutterSize: "none",
    responsive: false
  }, rest), items.map((item, i) => item == null ? undefined : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: i,
    grow: false
  }, item)));
};
exports.FilterButtonGroup = FilterButtonGroup;