"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterContent = FilterContent;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _filter_editor = require("../../filter_bar/filter_editor");
var _i18n = require("../i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const FilterValue = ({
  value
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: typeof value === 'string' ? 'success' : 'accent',
    className: "globalFilterLabel__value"
  }, ` ${value}`);
};
const FilterField = ({
  filter,
  fieldLabel
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Prefix, {
    prefix: filter.meta.negate
  }), fieldLabel || filter.meta.key, ":");
};
const Prefix = ({
  prefix
}) => prefix ? /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
  color: "danger"
}, _i18n.strings.getNotLabel()) : null;
function FilterContent({
  filter,
  valueLabel,
  fieldLabel,
  hideAlias
}) {
  if (!hideAlias && filter.meta.alias != null) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Prefix, {
      prefix: filter.meta.negate
    }), /*#__PURE__*/_react.default.createElement(FilterValue, {
      value: filter.meta.alias
    }));
  }
  switch (filter.meta.type) {
    case _esQuery.FILTERS.EXISTS:
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FilterField, {
        filter: filter,
        fieldLabel: fieldLabel
      }), /*#__PURE__*/_react.default.createElement(FilterValue, {
        value: `${_filter_editor.existsOperator.message}`
      }));
    case _esQuery.FILTERS.PHRASES:
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FilterField, {
        filter: filter,
        fieldLabel: fieldLabel
      }), /*#__PURE__*/_react.default.createElement(FilterValue, {
        value: `${_filter_editor.isOneOfOperator.message} ${valueLabel}`
      }));
    case _esQuery.FILTERS.QUERY_STRING:
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Prefix, {
        prefix: filter.meta.negate
      }), " ", /*#__PURE__*/_react.default.createElement(FilterValue, {
        value: valueLabel
      }));
    case _esQuery.FILTERS.PHRASE:
    case _esQuery.FILTERS.RANGE:
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FilterField, {
        filter: filter,
        fieldLabel: fieldLabel
      }), /*#__PURE__*/_react.default.createElement(FilterValue, {
        value: valueLabel
      }));
    default:
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Prefix, {
        prefix: filter.meta.negate
      }), /*#__PURE__*/_react.default.createElement(FilterValue, {
        value: `${JSON.stringify(filter.query) || filter.meta.value}`
      }));
  }
}