"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewsListLazy = exports.DataViewsList = exports.DataViewSelectorLazy = exports.DataViewSelector = exports.DataViewPickerLazy = exports.DataViewPicker = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxUtility = require("@kbn/shared-ux-utility");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * The Lazily-loaded `DataViewsList` component.  Consumers should use `React.Suspense` or
 * the withSuspense` HOC to load this component.
 */
const DataViewsListLazy = exports.DataViewsListLazy = /*#__PURE__*/_react.default.lazy(async () => {
  const {
    DataViewsList
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('../ui_module')));
  return {
    default: DataViewsList
  };
});

/**
 * A `DataViewsList` component that is wrapped by the `withSuspense` HOC. This component can
 * be used directly by consumers and will load the `DataViewsLazy` component lazily with
 * a predefined fallback and error boundary.
 */
const DataViewsList = exports.DataViewsList = (0, _sharedUxUtility.withSuspense)(DataViewsListLazy);

/**
 * The Lazily-loaded `DataViewSelector` component.  Consumers should use `React.Suspense` or
 * the withSuspense` HOC to load this component.
 */
const DataViewSelectorLazy = exports.DataViewSelectorLazy = /*#__PURE__*/_react.default.lazy(async () => {
  const {
    DataViewSelector
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('../ui_module')));
  return {
    default: DataViewSelector
  };
});

/**
 * A `DataViewSelector` component that is wrapped by the `withSuspense` HOC. This component can
 * be used directly by consumers and will load the `DataViewSelectorLazy` component lazily with
 * a predefined fallback and error boundary.
 */
const DataViewSelector = exports.DataViewSelector = (0, _sharedUxUtility.withSuspense)(DataViewSelectorLazy);

/**
 * The Lazily-loaded `DataViewPicker` component.  Consumers should use `React.Suspense` or
 * the withSuspense` HOC to load this component.
 */
const DataViewPickerLazy = exports.DataViewPickerLazy = /*#__PURE__*/_react.default.lazy(async () => {
  const {
    DataViewPicker
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('../ui_module')));
  return {
    default: DataViewPicker
  };
});

/**
 * A `DataViewPicker` component that is wrapped by the `withSuspense` HOC. This component can
 * be used directly by consumers and will load the `DataViewPickerLazy` component lazily with
 * a predefined fallback and error boundary.
 */
const DataViewPicker = exports.DataViewPicker = (0, _sharedUxUtility.withSuspense)(DataViewPickerLazy);