"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupGetValueSuggestions = void 0;
var _lodash = require("lodash");
var _esQuery = require("@kbn/es-query");
var _query_suggestion_provider = require("../query_suggestion_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const wrapAsSuggestions = (start, end, query, values) => values.filter(value => value.toLowerCase().includes(query.toLowerCase())).map(value => ({
  type: _query_suggestion_provider.QuerySuggestionTypes.Value,
  text: `${value} `,
  start,
  end
}));
const setupGetValueSuggestions = core => {
  const autoCompleteServicePromise = core.getStartServices().then(([_, __, dataStart]) => dataStart.autocomplete);
  return async ({
    indexPatterns,
    boolFilter,
    useTimeRange,
    signal,
    method,
    suggestionsAbstraction
  }, {
    start,
    end,
    prefix,
    suffix,
    fieldName,
    nestedPath
  }) => {
    const fullFieldName = nestedPath ? `${nestedPath}.${fieldName}` : fieldName;
    const indexPatternFieldEntries = [];
    indexPatterns.forEach(indexPattern => {
      indexPattern.fields.filter(field => field.name === fullFieldName).forEach(field => indexPatternFieldEntries.push([indexPattern, field]));
    });
    const query = `${prefix}${suffix}`.trim();
    const {
      getValueSuggestions
    } = await autoCompleteServicePromise;
    const data = await Promise.all(indexPatternFieldEntries.map(([indexPattern, field]) => getValueSuggestions({
      indexPattern,
      field,
      query,
      boolFilter,
      useTimeRange,
      signal,
      method,
      querySuggestionKey: suggestionsAbstraction === null || suggestionsAbstraction === void 0 ? void 0 : suggestionsAbstraction.type
    }).then(valueSuggestions => {
      const quotedValues = valueSuggestions.map(value => typeof value === 'string' ? `"${(0, _esQuery.escapeQuotes)(value)}"` : `${value}`);
      return wrapAsSuggestions(start, end, query, quotedValues);
    })));
    return (0, _lodash.flatten)(data);
  };
};
exports.setupGetValueSuggestions = setupGetValueSuggestions;