"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TIMESTAMP_COLUMN = void 0;
exports.canImportVisContext = canImportVisContext;
exports.deriveLensSuggestionFromLensAttributes = deriveLensSuggestionFromLensAttributes;
exports.isSuggestionShapeAndVisContextCompatible = exports.injectESQLQueryIntoLensLayers = exports.exportVisContext = void 0;
var _lodash = require("lodash");
var _visualizationUtils = require("@kbn/visualization-utils");
var _types = require("../types");
var _lens_vis_from_table = require("./lens_vis_from_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TIMESTAMP_COLUMN = exports.TIMESTAMP_COLUMN = 'timestamp';
const exportVisContext = visContext => {
  if (!visContext || !visContext.requestData || !visContext.attributes || !visContext.suggestionType) {
    return undefined;
  }
  try {
    const lightweightVisContext = visContext ? {
      suggestionType: visContext.suggestionType,
      requestData: visContext.requestData,
      attributes: (0, _lens_vis_from_table.removeTablesFromLensAttributes)(visContext.attributes).attributes
    } : undefined;
    const visContextWithoutUndefinedValues = lightweightVisContext ? JSON.parse(JSON.stringify(lightweightVisContext)) : undefined;
    return visContextWithoutUndefinedValues;
  } catch {
    return undefined;
  }
};
exports.exportVisContext = exportVisContext;
function canImportVisContext(visContext) {
  return !!visContext && typeof visContext === 'object' && 'requestData' in visContext && 'attributes' in visContext && 'suggestionType' in visContext && !!visContext.requestData && !!visContext.attributes && !!visContext.suggestionType && typeof visContext.requestData === 'object' && typeof visContext.attributes === 'object' && typeof visContext.suggestionType === 'string';
}
const isSuggestionShapeAndVisContextCompatible = (suggestion, externalVisContext) => {
  var _externalVisContext$a, _suggestion$visualiza2, _externalVisContext$a5, _externalVisContext$a6, _externalVisContext$a7;
  if (!suggestion && !externalVisContext) {
    return true;
  }
  if ((suggestion === null || suggestion === void 0 ? void 0 : suggestion.visualizationId) !== (externalVisContext === null || externalVisContext === void 0 ? void 0 : (_externalVisContext$a = externalVisContext.attributes) === null || _externalVisContext$a === void 0 ? void 0 : _externalVisContext$a.visualizationType)) {
    return false;
  }
  if ((externalVisContext === null || externalVisContext === void 0 ? void 0 : externalVisContext.suggestionType) !== _types.UnifiedHistogramSuggestionType.lensSuggestion) {
    return true;
  }
  if ((suggestion === null || suggestion === void 0 ? void 0 : suggestion.visualizationId) === 'lnsXY') {
    var _suggestion$visualiza, _externalVisContext$a2, _externalVisContext$a3, _externalVisContext$a4;
    return (suggestion === null || suggestion === void 0 ? void 0 : (_suggestion$visualiza = suggestion.visualizationState) === null || _suggestion$visualiza === void 0 ? void 0 : _suggestion$visualiza.preferredSeriesType) === (externalVisContext === null || externalVisContext === void 0 ? void 0 : (_externalVisContext$a2 = externalVisContext.attributes) === null || _externalVisContext$a2 === void 0 ? void 0 : (_externalVisContext$a3 = _externalVisContext$a2.state) === null || _externalVisContext$a3 === void 0 ? void 0 : (_externalVisContext$a4 = _externalVisContext$a3.visualization) === null || _externalVisContext$a4 === void 0 ? void 0 : _externalVisContext$a4.preferredSeriesType);
  }
  return (suggestion === null || suggestion === void 0 ? void 0 : (_suggestion$visualiza2 = suggestion.visualizationState) === null || _suggestion$visualiza2 === void 0 ? void 0 : _suggestion$visualiza2.shape) === (externalVisContext === null || externalVisContext === void 0 ? void 0 : (_externalVisContext$a5 = externalVisContext.attributes) === null || _externalVisContext$a5 === void 0 ? void 0 : (_externalVisContext$a6 = _externalVisContext$a5.state) === null || _externalVisContext$a6 === void 0 ? void 0 : (_externalVisContext$a7 = _externalVisContext$a6.visualization) === null || _externalVisContext$a7 === void 0 ? void 0 : _externalVisContext$a7.shape);
};
exports.isSuggestionShapeAndVisContextCompatible = isSuggestionShapeAndVisContextCompatible;
const injectIntervalToDateTimeColumn = (columns, dateFieldLabel) => {
  const dateColumn = columns.find(column => column.columnId === TIMESTAMP_COLUMN);
  if (dateColumn && dateColumn.label !== dateFieldLabel && dateColumn.customLabel) {
    dateColumn.label = dateFieldLabel;
  }
  return columns;
};
const injectESQLQueryIntoLensLayers = (visAttributes, query, dateFieldLabel) => {
  const datasourceId = (0, _visualizationUtils.getDatasourceId)(visAttributes.state.datasourceStates);

  // if the datasource is formBased, we should not fix the query
  if (!datasourceId || datasourceId === 'formBased') {
    return visAttributes;
  }
  if (!visAttributes.state.datasourceStates[datasourceId]) {
    return visAttributes;
  }
  const datasourceState = (0, _lodash.cloneDeep)(visAttributes.state.datasourceStates[datasourceId]);
  if (datasourceState && datasourceState.layers) {
    Object.values(datasourceState.layers).forEach(layer => {
      if (!(0, _lodash.isEqual)(layer.query, query)) {
        layer.query = query;
      }
      if (dateFieldLabel && layer.columns) {
        const columns = injectIntervalToDateTimeColumn(layer.columns, dateFieldLabel);
        if (!(0, _lodash.isEqual)(layer.columns, columns)) {
          layer.columns = columns;
        }
      }
    });
  }
  return {
    ...visAttributes,
    state: {
      ...visAttributes.state,
      datasourceStates: {
        ...visAttributes.state.datasourceStates,
        [datasourceId]: datasourceState
      }
    }
  };
};
exports.injectESQLQueryIntoLensLayers = injectESQLQueryIntoLensLayers;
function deriveLensSuggestionFromLensAttributes({
  externalVisContext,
  queryParams
}) {
  if (!externalVisContext) {
    return undefined;
  }
  try {
    if (externalVisContext.suggestionType === _types.UnifiedHistogramSuggestionType.lensSuggestion) {
      var _externalVisContext$a8, _externalVisContext$a9;
      // should be based on same query
      if (queryParams && !(0, _lodash.isEqual)((_externalVisContext$a8 = externalVisContext.attributes) === null || _externalVisContext$a8 === void 0 ? void 0 : (_externalVisContext$a9 = _externalVisContext$a8.state) === null || _externalVisContext$a9 === void 0 ? void 0 : _externalVisContext$a9.query, queryParams.query)) {
        return undefined;
      }

      // it should be one of 'formBased'/'textBased' and have value
      const datasourceId = (0, _visualizationUtils.getDatasourceId)(externalVisContext.attributes.state.datasourceStates);
      if (!datasourceId) {
        return undefined;
      }
      const datasourceState = externalVisContext.attributes.state.datasourceStates[datasourceId];

      // should be based on same columns
      if (queryParams && (!(datasourceState !== null && datasourceState !== void 0 && datasourceState.layers) || Object.values(datasourceState === null || datasourceState === void 0 ? void 0 : datasourceState.layers).some(layer => {
        var _layer$columns;
        return (0, _lodash.isEqual)(layer.query, queryParams.query) && ((_layer$columns = layer.columns) === null || _layer$columns === void 0 ? void 0 : _layer$columns.some(
        // unknown column
        c => {
          var _queryParams$columnsM;
          return !((_queryParams$columnsM = queryParams.columnsMap) !== null && _queryParams$columnsM !== void 0 && _queryParams$columnsM[c.fieldName]);
        }));
      }))) {
        return undefined;
      }
      return {
        title: externalVisContext.attributes.title,
        visualizationId: externalVisContext.attributes.visualizationType,
        visualizationState: externalVisContext.attributes.state.visualization,
        datasourceState,
        datasourceId
      };
    }
  } catch {
    return undefined;
  }
  return undefined;
}