"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeIntervalSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _toolbar_selector = require("./toolbar_selector");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TimeIntervalSelector = ({
  chart,
  onTimeIntervalChange
}) => {
  const onChange = (0, _react.useCallback)(chosenOption => {
    const selectedOption = chosenOption === null || chosenOption === void 0 ? void 0 : chosenOption.value;
    if (selectedOption) {
      onTimeIntervalChange(selectedOption);
    }
  }, [onTimeIntervalChange]);
  const selectedOptionIdx = _public.search.aggs.intervalOptions.findIndex(opt => opt.val === chart.timeInterval);
  const intervalDisplay = selectedOptionIdx > -1 ? _public.search.aggs.intervalOptions[selectedOptionIdx].display : _public.search.aggs.intervalOptions[0].display;
  const options = _public.search.aggs.intervalOptions.filter(({
    val
  }) => val !== 'custom').map(({
    display,
    val
  }) => {
    return {
      key: val,
      value: val,
      label: display,
      checked: val === chart.timeInterval ? 'on' : undefined
    };
  });
  return /*#__PURE__*/_react.default.createElement(_toolbar_selector.ToolbarSelector, {
    "data-test-subj": "unifiedHistogramTimeIntervalSelector",
    "data-selected-value": chart.timeInterval,
    searchable: false,
    buttonLabel: chart.timeInterval !== 'auto' ? _i18n.i18n.translate('unifiedHistogram.timeIntervalSelector.buttonLabel', {
      defaultMessage: `Interval: {timeInterval}`,
      values: {
        timeInterval: intervalDisplay.toLowerCase()
      }
    }) : _i18n.i18n.translate('unifiedHistogram.timeIntervalSelector.autoIntervalButtonLabel', {
      defaultMessage: 'Auto interval'
    }),
    popoverTitle: _i18n.i18n.translate('unifiedHistogram.timeIntervalSelector.timeIntervalPopoverTitle', {
      defaultMessage: 'Select time interval'
    }),
    options: options,
    onChange: onChange
  });
};
exports.TimeIntervalSelector = TimeIntervalSelector;