"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpanDurationSummary = SpanDurationSummary;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _apmUiShared = require("@kbn/apm-ui-shared");
var _apmTypesShared = require("@kbn/apm-types-shared");
var _use_root_span = require("../../hooks/use_root_span");
var _use_span_latency_chart = require("../../hooks/use_span_latency_chart");
var _field_without_actions = require("../../../components/field_without_actions");
var _section = require("../../../components/section");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function SpanDurationSummary({
  spanDuration,
  spanName,
  serviceName,
  isOtelSpan
}) {
  var _latencyChartData$spa, _latencyChartData$per;
  const {
    trace,
    loading
  } = (0, _use_root_span.useRootSpanContext)();
  const {
    data: latencyChartData,
    loading: latencyChartLoading,
    hasError: latencyChartHasError
  } = (0, _use_span_latency_chart.useSpanLatencyChart)({
    spanName,
    serviceName,
    isOtelSpan
  });
  return /*#__PURE__*/_react.default.createElement(_section.Section, {
    title: _i18n.i18n.translate('unifiedDocViewer.observability.traces.docViewerSpanOverview.spanDurationSummary.title', {
      defaultMessage: 'Duration'
    }),
    subtitle: _i18n.i18n.translate('unifiedDocViewer.observability.traces.docViewerSpanOverview.spanDurationSummary.description', {
      defaultMessage: 'Time taken to complete this span from start to finish.'
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_without_actions.FieldWithoutActions, {
    label: _i18n.i18n.translate('unifiedDocViewer.observability.traces.docViewerSpanOverview.spanDurationSummary.duration.title', {
      defaultMessage: 'Duration'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_apmUiShared.Duration, {
    duration: spanDuration,
    parent: {
      loading,
      duration: trace === null || trace === void 0 ? void 0 : trace.duration,
      type: 'transaction'
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('unifiedDocViewer.observability.traces.docViewerTransactionOverview.spanDurationSummary.latency.title', {
    defaultMessage: 'Latency'
  }))), (latencyChartLoading || latencyChartData) && /*#__PURE__*/_react.default.createElement(_apmUiShared.DurationDistributionChart, {
    data: (_latencyChartData$spa = latencyChartData === null || latencyChartData === void 0 ? void 0 : latencyChartData.spanDistributionChartData) !== null && _latencyChartData$spa !== void 0 ? _latencyChartData$spa : [],
    markerValue: (_latencyChartData$per = latencyChartData === null || latencyChartData === void 0 ? void 0 : latencyChartData.percentileThresholdValue) !== null && _latencyChartData$per !== void 0 ? _latencyChartData$per : 0,
    markerCurrentEvent: spanDuration,
    hasData: !!latencyChartData,
    loading: latencyChartLoading,
    hasError: latencyChartHasError,
    eventType: _apmTypesShared.ProcessorEvent.span,
    showAxisTitle: false,
    showLegend: false,
    isOtelData: isOtelSpan,
    dataTestSubPrefix: "docViewerSpanOverview"
  })))));
}