"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocViewTableRowBtnToggleColumn = DocViewTableRowBtnToggleColumn;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function DocViewTableRowBtnToggleColumn({
  onClick,
  active,
  disabled = false,
  fieldname = ''
}) {
  if (disabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('unifiedDocViewer.docViews.table.toggleColumnInTableButtonAriaLabel', {
        defaultMessage: 'Toggle column in table'
      }),
      className: "kbnDocViewer__actionButton",
      "data-test-subj": "toggleColumnButton",
      disabled: true,
      iconType: 'listAdd',
      iconSize: 's'
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedDocViewer.docViews.table.toggleColumnInTableButtonTooltip",
      defaultMessage: "Toggle column in table"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('unifiedDocViewer.docViews.table.toggleColumnInTableButtonAriaLabel', {
      defaultMessage: 'Toggle column in table'
    }),
    "aria-pressed": active,
    onClick: onClick,
    className: "kbnDocViewer__actionButton",
    "data-test-subj": `toggleColumnButton-${fieldname}`,
    iconType: 'listAdd',
    iconSize: 's'
  }));
}