"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocViewerLegacyTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _get_field_icon_type = require("@kbn/field-utils/src/utils/get_field_icon_type");
var _discoverUtils = require("@kbn/discover-utils");
var _plugin = require("../../../plugin");
var _table_columns = require("./table_columns");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DocViewerLegacyTable = ({
  columns,
  hit,
  dataView,
  hideActionsColumn,
  filter,
  onAddColumn,
  onRemoveColumn
}) => {
  const {
    fieldFormats,
    uiSettings
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const showMultiFields = (0, _react.useMemo)(() => uiSettings.get(_discoverUtils.SHOW_MULTIFIELDS), [uiSettings]);
  const mapping = (0, _react.useCallback)(name => dataView.fields.getByName(name), [dataView.fields]);
  const tableColumns = (0, _react.useMemo)(() => {
    return !hideActionsColumn ? [_table_columns.ACTIONS_COLUMN, ..._table_columns.MAIN_COLUMNS] : _table_columns.MAIN_COLUMNS;
  }, [hideActionsColumn]);
  const onToggleColumn = (0, _react.useMemo)(() => {
    if (!onRemoveColumn || !onAddColumn || !columns) {
      return undefined;
    }
    return field => {
      if (columns.includes(field)) {
        onRemoveColumn(field);
      } else {
        onAddColumn(field);
      }
    };
  }, [onRemoveColumn, onAddColumn, columns]);
  const onSetRowProps = (0, _react.useCallback)(({
    field: {
      field
    }
  }) => {
    return {
      key: field,
      className: 'kbnDocViewer__tableRow',
      'data-test-subj': `tableDocViewRow-${field}`
    };
  }, []);
  const shouldShowFieldHandler = (0, _react.useMemo)(() => (0, _discoverUtils.getShouldShowFieldHandler)(Object.keys(hit.flattened), dataView, showMultiFields), [hit.flattened, dataView, showMultiFields]);
  const items = Object.keys(hit.flattened).filter(shouldShowFieldHandler).sort((fieldA, fieldB) => {
    const mappingA = mapping(fieldA);
    const mappingB = mapping(fieldB);
    const nameA = !mappingA || !mappingA.displayName ? fieldA : mappingA.displayName;
    const nameB = !mappingB || !mappingB.displayName ? fieldB : mappingB.displayName;
    return nameA.localeCompare(nameB);
  }).map(field => {
    var _fieldMapping$display;
    const fieldMapping = mapping(field);
    const displayName = (_fieldMapping$display = fieldMapping === null || fieldMapping === void 0 ? void 0 : fieldMapping.displayName) !== null && _fieldMapping$display !== void 0 ? _fieldMapping$display : field;
    const fieldType = (0, _discoverUtils.isNestedFieldParent)(field, dataView) ? 'nested' : fieldMapping ? (0, _get_field_icon_type.getFieldIconType)(fieldMapping) : undefined;
    const ignored = (0, _discoverUtils.getIgnoredReason)(fieldMapping !== null && fieldMapping !== void 0 ? fieldMapping : field, hit.raw._ignored);
    return {
      action: {
        onToggleColumn,
        onFilter: filter,
        isActive: !!(columns !== null && columns !== void 0 && columns.includes(field)),
        flattenedField: hit.flattened[field]
      },
      field: {
        field,
        displayName,
        fieldMapping,
        fieldType,
        scripted: Boolean(fieldMapping === null || fieldMapping === void 0 ? void 0 : fieldMapping.scripted)
      },
      value: {
        formattedValue: (0, _discoverUtils.formatFieldValue)(hit.flattened[field], hit.raw, fieldFormats, dataView, fieldMapping),
        ignored
      }
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    tableLayout: "auto",
    className: "kbnDocViewer__table",
    items: items,
    columns: tableColumns,
    rowProps: onSetRowProps,
    responsiveBreakpoint: false
  });
};
exports.DocViewerLegacyTable = DocViewerLegacyTable;