"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightSection = HighlightSection;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function HighlightSection({
  children,
  title,
  visibleItems = 6,
  ...props
}) {
  const validChildren = _react.default.Children.toArray(children).filter(Boolean);
  const childrenLength = validChildren.length;
  const shouldRenderSection = childrenLength > 0;
  const limitedChildren = validChildren.slice(0, visibleItems - 1);
  const [isListExpanded, expandList] = (0, _react.useReducer)(() => true, childrenLength <= visibleItems);
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: title
  });
  const showMoreButtonLabel = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.section.showMore', {
    defaultMessage: '+ {count} more',
    values: {
      count: childrenLength - limitedChildren.length
    }
  });
  const showMoreButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    key: title,
    "data-test-subj": "unifiedDocViewLogsOverviewHighlightSectionShowMoreButton",
    size: "xs",
    flush: "left",
    css: {
      width: '80px'
    },
    onClick: expandList
  }, showMoreButtonLabel);
  limitedChildren.push(showMoreButton);
  const accordionTitle = /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, title));
  const displayedItems = isListExpanded ? validChildren : limitedChildren;
  return shouldRenderSection ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, (0, _extends2.default)({
    id: accordionId,
    buttonContent: accordionTitle,
    paddingSize: "m",
    initialIsOpen: true
  }, props), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    css: gridStyle,
    alignItems: "start",
    gutterSize: "m"
  }, displayedItems)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  })) : null;
}

// Applying this custom css rule remove the need for custom runtime js to compute a responsive column layout
const gridStyle = (0, _react2.css)`
  grid-template-columns: repeat(auto-fill, minmax(340px, 1fr));
`;