"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsOverviewHighlights = LogsOverviewHighlights;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _customIcons = require("@kbn/custom-icons");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _discoverUtils = require("@kbn/discover-utils");
var _highlight_field = require("./sub_components/highlight_field");
var _highlight_section = require("./sub_components/highlight_section");
var _plugin = require("../../plugin");
var _trace_id_highlight_field = require("./sub_components/trace_id_highlight_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function LogsOverviewHighlights({
  formattedDoc,
  doc,
  renderStreamsField
}) {
  var _flattenedDoc$fieldCo;
  const flattenedDoc = doc.flattened;
  const {
    fieldsMetadata: {
      useFieldsMetadata
    }
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const {
    fieldsMetadata = {}
  } = useFieldsMetadata({
    attributes: ['flat_name', 'short', 'type'],
    fieldNames: [_discoverUtils.fieldConstants.SERVICE_NAME_FIELD, _discoverUtils.fieldConstants.HOST_NAME_FIELD, _discoverUtils.fieldConstants.TRACE_ID_FIELD, _discoverUtils.fieldConstants.ORCHESTRATOR_CLUSTER_NAME_FIELD, _discoverUtils.fieldConstants.ORCHESTRATOR_RESOURCE_ID_FIELD, _discoverUtils.fieldConstants.CLOUD_PROVIDER_FIELD, _discoverUtils.fieldConstants.CLOUD_REGION_FIELD, _discoverUtils.fieldConstants.CLOUD_AVAILABILITY_ZONE_FIELD, _discoverUtils.fieldConstants.CLOUD_PROJECT_ID_FIELD, _discoverUtils.fieldConstants.CLOUD_INSTANCE_ID_FIELD, _discoverUtils.fieldConstants.LOG_FILE_PATH_FIELD, _discoverUtils.fieldConstants.DATASTREAM_DATASET_FIELD, _discoverUtils.fieldConstants.DATASTREAM_NAMESPACE_FIELD, _discoverUtils.fieldConstants.AGENT_NAME_FIELD]
  });
  const getHighlightProps = field => ({
    field,
    formattedValue: formattedDoc[field],
    value: flattenedDoc[field]
  });
  const shouldRenderHighlight = field => {
    return Boolean(formattedDoc[field] && flattenedDoc[field]);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_highlight_section.HighlightSection, {
    title: serviceInfraAccordionTitle,
    "data-test-subj": "unifiedDocViewLogsOverviewHighlightSectionServiceInfra"
  }, shouldRenderHighlight(_discoverUtils.fieldConstants.SERVICE_NAME_FIELD) && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, (0, _extends2.default)({
    "data-test-subj": "unifiedDocViewLogsOverviewService",
    label: serviceLabel,
    fieldMetadata: fieldsMetadata[_discoverUtils.fieldConstants.SERVICE_NAME_FIELD]
  }, getHighlightProps(_discoverUtils.fieldConstants.SERVICE_NAME_FIELD), {
    truncate: true
  })), shouldRenderHighlight(_discoverUtils.fieldConstants.HOST_NAME_FIELD) && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, (0, _extends2.default)({
    "data-test-subj": "unifiedDocViewLogsOverviewHostName",
    label: hostNameLabel,
    fieldMetadata: fieldsMetadata[_discoverUtils.fieldConstants.HOST_NAME_FIELD]
  }, getHighlightProps(_discoverUtils.fieldConstants.HOST_NAME_FIELD), {
    truncate: true
  })), shouldRenderHighlight(_discoverUtils.fieldConstants.TRACE_ID_FIELD) && /*#__PURE__*/_react.default.createElement(_trace_id_highlight_field.TraceIdHighlightField, (0, _extends2.default)({
    "data-test-subj": "unifiedDocViewLogsOverviewTrace",
    label: traceLabel,
    fieldMetadata: fieldsMetadata[_discoverUtils.fieldConstants.TRACE_ID_FIELD]
  }, getHighlightProps(_discoverUtils.fieldConstants.TRACE_ID_FIELD), {
    truncate: true
  })), shouldRenderHighlight(_discoverUtils.fieldConstants.ORCHESTRATOR_CLUSTER_NAME_FIELD) && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, (0, _extends2.default)({
    "data-test-subj": "unifiedDocViewLogsOverviewClusterName",
    label: orchestratorClusterNameLabel,
    fieldMetadata: fieldsMetadata[_discoverUtils.fieldConstants.ORCHESTRATOR_CLUSTER_NAME_FIELD]
  }, getHighlightProps(_discoverUtils.fieldConstants.ORCHESTRATOR_CLUSTER_NAME_FIELD), {
    truncate: true
  })), shouldRenderHighlight(_discoverUtils.fieldConstants.ORCHESTRATOR_RESOURCE_ID_FIELD) && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, (0, _extends2.default)({
    "data-test-subj": "unifiedDocViewLogsOverviewResourceId",
    label: orchestratorResourceIdLabel,
    fieldMetadata: fieldsMetadata[_discoverUtils.fieldConstants.ORCHESTRATOR_RESOURCE_ID_FIELD]
  }, getHighlightProps(_discoverUtils.fieldConstants.ORCHESTRATOR_RESOURCE_ID_FIELD), {
    truncate: true
  }))), /*#__PURE__*/_react.default.createElement(_highlight_section.HighlightSection, {
    title: cloudAccordionTitle,
    "data-test-subj": "unifiedDocViewLogsOverviewHighlightSectionCloud"
  }, shouldRenderHighlight(_discoverUtils.fieldConstants.CLOUD_PROVIDER_FIELD) && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, (0, _extends2.default)({
    "data-test-subj": "unifiedDocViewLogsOverviewCloudProvider",
    label: cloudProviderLabel,
    fieldMetadata: fieldsMetadata[_discoverUtils.fieldConstants.CLOUD_PROVIDER_FIELD],
    icon: /*#__PURE__*/_react.default.createElement(_customIcons.CloudProviderIcon, {
      cloudProvider: (0, _lodash.first)((_flattenedDoc$fieldCo = flattenedDoc[_discoverUtils.fieldConstants.CLOUD_PROVIDER_FIELD]) !== null && _flattenedDoc$fieldCo !== void 0 ? _flattenedDoc$fieldCo : [])
    })
  }, getHighlightProps(_discoverUtils.fieldConstants.CLOUD_PROVIDER_FIELD))), shouldRenderHighlight(_discoverUtils.fieldConstants.CLOUD_REGION_FIELD) && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, (0, _extends2.default)({
    "data-test-subj": "unifiedDocViewLogsOverviewCloudRegion",
    label: cloudRegionLabel,
    fieldMetadata: fieldsMetadata[_discoverUtils.fieldConstants.CLOUD_REGION_FIELD]
  }, getHighlightProps(_discoverUtils.fieldConstants.CLOUD_REGION_FIELD), {
    truncate: true
  })), shouldRenderHighlight(_discoverUtils.fieldConstants.CLOUD_AVAILABILITY_ZONE_FIELD) && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, (0, _extends2.default)({
    "data-test-subj": "unifiedDocViewLogsOverviewCloudAz",
    label: cloudAvailabilityZoneLabel,
    fieldMetadata: fieldsMetadata[_discoverUtils.fieldConstants.CLOUD_AVAILABILITY_ZONE_FIELD]
  }, getHighlightProps(_discoverUtils.fieldConstants.CLOUD_AVAILABILITY_ZONE_FIELD), {
    truncate: true
  })), shouldRenderHighlight(_discoverUtils.fieldConstants.CLOUD_PROJECT_ID_FIELD) && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, (0, _extends2.default)({
    "data-test-subj": "unifiedDocViewLogsOverviewCloudProjectId",
    label: cloudProjectIdLabel,
    fieldMetadata: fieldsMetadata[_discoverUtils.fieldConstants.CLOUD_PROJECT_ID_FIELD]
  }, getHighlightProps(_discoverUtils.fieldConstants.CLOUD_PROJECT_ID_FIELD), {
    truncate: true
  })), shouldRenderHighlight(_discoverUtils.fieldConstants.CLOUD_INSTANCE_ID_FIELD) && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, (0, _extends2.default)({
    "data-test-subj": "unifiedDocViewLogsOverviewCloudInstanceId",
    label: cloudInstanceIdLabel,
    fieldMetadata: fieldsMetadata[_discoverUtils.fieldConstants.CLOUD_INSTANCE_ID_FIELD]
  }, getHighlightProps(_discoverUtils.fieldConstants.CLOUD_INSTANCE_ID_FIELD), {
    truncate: true
  }))), /*#__PURE__*/_react.default.createElement(_highlight_section.HighlightSection, {
    title: otherAccordionTitle,
    "data-test-subj": "unifiedDocViewLogsOverviewHighlightSectionOther"
  }, shouldRenderHighlight(_discoverUtils.fieldConstants.LOG_FILE_PATH_FIELD) && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, (0, _extends2.default)({
    "data-test-subj": "unifiedDocViewLogsOverviewLogPathFile",
    label: logPathFileLabel,
    fieldMetadata: fieldsMetadata[_discoverUtils.fieldConstants.LOG_FILE_PATH_FIELD]
  }, getHighlightProps(_discoverUtils.fieldConstants.LOG_FILE_PATH_FIELD), {
    truncate: true
  })), shouldRenderHighlight(_discoverUtils.fieldConstants.DATASTREAM_DATASET_FIELD) && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, (0, _extends2.default)({
    "data-test-subj": "unifiedDocViewLogsOverviewDataset",
    label: datasetLabel,
    fieldMetadata: fieldsMetadata[_discoverUtils.fieldConstants.DATASTREAM_DATASET_FIELD]
  }, getHighlightProps(_discoverUtils.fieldConstants.DATASTREAM_DATASET_FIELD), {
    truncate: true
  })), shouldRenderHighlight(_discoverUtils.fieldConstants.DATASTREAM_NAMESPACE_FIELD) && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, (0, _extends2.default)({
    "data-test-subj": "unifiedDocViewLogsOverviewNamespace",
    label: namespaceLabel,
    fieldMetadata: fieldsMetadata[_discoverUtils.fieldConstants.DATASTREAM_NAMESPACE_FIELD],
    useBadge: true
  }, getHighlightProps(_discoverUtils.fieldConstants.DATASTREAM_NAMESPACE_FIELD), {
    truncate: true
  })), renderStreamsField && renderStreamsField({
    doc
  }), shouldRenderHighlight(_discoverUtils.fieldConstants.AGENT_NAME_FIELD) && /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, (0, _extends2.default)({
    "data-test-subj": "unifiedDocViewLogsOverviewLogShipper",
    label: shipperLabel,
    fieldMetadata: fieldsMetadata[_discoverUtils.fieldConstants.AGENT_NAME_FIELD]
  }, getHighlightProps(_discoverUtils.fieldConstants.AGENT_NAME_FIELD), {
    truncate: true
  }))));
}
const serviceLabel = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.label.service', {
  defaultMessage: 'Service'
});
const traceLabel = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.label.trace', {
  defaultMessage: 'Trace'
});
const hostNameLabel = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.label.hostName', {
  defaultMessage: 'Host name'
});
const serviceInfraAccordionTitle = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.accordion.title.serviceInfra', {
  defaultMessage: 'Service & Infrastructure'
});
const cloudAccordionTitle = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.accordion.title.cloud', {
  defaultMessage: 'Cloud'
});
const otherAccordionTitle = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.accordion.title.other', {
  defaultMessage: 'Other'
});
const orchestratorClusterNameLabel = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.label.orchestratorClusterName', {
  defaultMessage: 'Orchestrator cluster Name'
});
const orchestratorResourceIdLabel = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.label.orchestratorResourceId', {
  defaultMessage: 'Orchestrator resource ID'
});
const cloudProviderLabel = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.label.cloudProvider', {
  defaultMessage: 'Cloud provider'
});
const cloudRegionLabel = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.label.cloudRegion', {
  defaultMessage: 'Cloud region'
});
const cloudAvailabilityZoneLabel = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.label.cloudAvailabilityZone', {
  defaultMessage: 'Cloud availability zone'
});
const cloudProjectIdLabel = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.label.cloudProjectId', {
  defaultMessage: 'Cloud project ID'
});
const cloudInstanceIdLabel = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.label.cloudInstanceId', {
  defaultMessage: 'Cloud instance ID'
});
const logPathFileLabel = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.label.logPathFile', {
  defaultMessage: 'Log path file'
});
const namespaceLabel = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.label.namespace', {
  defaultMessage: 'Namespace'
});
const datasetLabel = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.label.dataset', {
  defaultMessage: 'Dataset'
});
const shipperLabel = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.label.shipper', {
  defaultMessage: 'Shipper'
});