"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TriggerInternal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _trigger_contract = require("./trigger_contract");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Internal representation of a trigger kept for consumption only internally
 * within `ui_actions` plugin.
 */
class TriggerInternal {
  constructor(service, trigger) {
    (0, _defineProperty2.default)(this, "contract", void 0);
    this.service = service;
    this.trigger = trigger;
    this.contract = new _trigger_contract.TriggerContract(this);
  }
  async execute(context, alwaysShowPopup) {
    const triggerId = this.trigger.id;
    const actions = await this.service.getTriggerCompatibleActions(triggerId, context);
    await Promise.all([actions.map(action => this.service.executionService.execute({
      action,
      context,
      trigger: this.trigger
    }, alwaysShowPopup))]);
  }
}
exports.TriggerInternal = TriggerInternal;