"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexOptions = exports.getFields = exports.firstFieldOption = void 0;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _data_apis = require("../lib/data_apis");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIndexOptions = async (http, pattern) => {
  const options = [];
  if (!pattern) {
    return options;
  }
  const [matchingIndices, matchingIndexPatterns] = await Promise.all([(0, _data_apis.getMatchingIndices)({
    pattern,
    http
  }), (0, _data_apis.loadIndexPatterns)(pattern)]);
  if (matchingIndices.length || matchingIndexPatterns.length) {
    const matchingOptions = (0, _lodash.uniq)([...matchingIndices, ...matchingIndexPatterns]);
    options.push({
      label: _i18n.i18n.translate('xpack.triggersActionsUI.components.builtinActionTypes.indexAction.indicesAndIndexPatternsLabel', {
        defaultMessage: 'Based on your data views'
      }),
      options: matchingOptions.map(match => {
        return {
          label: match,
          value: match
        };
      })
    });
  }
  options.push({
    label: _i18n.i18n.translate('xpack.triggersActionsUI.components.builtinActionTypes.indexAction.chooseLabel', {
      defaultMessage: 'Choose…'
    }),
    options: [{
      value: pattern,
      label: pattern
    }]
  });
  return options;
};
exports.getIndexOptions = getIndexOptions;
const getFields = async (http, indexes) => {
  return await (0, _data_apis.getESIndexFields)({
    indexes,
    http
  });
};
exports.getFields = getFields;
const firstFieldOption = exports.firstFieldOption = {
  text: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleAdd.indexControls.timeFieldOptionLabel', {
    defaultMessage: 'Select a field'
  }),
  value: ''
};