"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateConnectorFilter = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateConnectorFilter = ({
  searchValue,
  onSearchValueChange
}) => {
  const handleSearchChange = e => {
    const newValue = e.target.value;
    onSearchValueChange(newValue);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    wrap: false,
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionConnectorAdd.searchConnector', {
      defaultMessage: 'Search'
    }),
    "data-test-subj": "createConnectorsModalSearch",
    onChange: handleSearchChange,
    value: searchValue
  })));
};
exports.CreateConnectorFilter = CreateConnectorFilter;