"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorFormFieldsGlobal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _helpers.fieldValidators;
const nameConfig = {
  label: 'Connector name',
  validations: [{
    validator: emptyField(_i18n.i18n.translate('xpack.triggersActionsUI.sections.actionConnectorForm.error.requiredNameText', {
      defaultMessage: 'Name is required.'
    }))
  }]
};
const ConnectorFormFieldsGlobalComponent = ({
  canSave
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "id",
    component: _components.HiddenField
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "actionTypeId",
    component: _components.HiddenField
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "isDeprecated",
    component: _components.HiddenField
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "name",
    config: nameConfig,
    component: _components.Field,
    componentProps: {
      euiFieldProps: {
        readOnly: !canSave,
        'data-test-subj': 'nameInput',
        fullWidth: true
      }
    }
  }));
};
const ConnectorFormFieldsGlobal = exports.ConnectorFormFieldsGlobal = /*#__PURE__*/(0, _react.memo)(ConnectorFormFieldsGlobalComponent);