"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkSnoozeRules = bulkSnoozeRules;
exports.snoozeRule = snoozeRule;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function rewriteSnoozeSchedule({
  id,
  duration,
  rRule
}) {
  return {
    ...(id ? {
      id
    } : {}),
    duration,
    rRule: {
      ...rRule,
      ...(rRule.until ? {
        until: rRule.until.toISOString()
      } : {})
    }
  };
}
async function snoozeRule({
  id,
  snoozeSchedule,
  http
}) {
  await http.post(`${_constants.INTERNAL_BASE_ALERTING_API_PATH}/rule/${encodeURIComponent(id)}/_snooze`, {
    body: JSON.stringify({
      snooze_schedule: rewriteSnoozeSchedule(snoozeSchedule)
    })
  });
}
function bulkSnoozeRules({
  ids,
  filter,
  snoozeSchedule,
  http
}) {
  let body;
  try {
    body = JSON.stringify({
      ids: ids !== null && ids !== void 0 && ids.length ? ids : undefined,
      ...(filter ? {
        filter: JSON.stringify(filter)
      } : {}),
      operations: [{
        operation: 'set',
        field: 'snoozeSchedule',
        value: rewriteSnoozeSchedule(snoozeSchedule)
      }]
    });
  } catch (e) {
    throw new Error(`Unable to parse bulk snooze params: ${e}`);
  }
  return http.post(`${_constants.INTERNAL_BASE_ALERTING_API_PATH}/rules/_bulk_edit`, {
    body
  });
}