"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadRuleSummary = loadRuleSummary;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformExecutionDuration = ({
  values_with_timestamp: valuesWithTimestamp,
  ...rest
}) => ({
  valuesWithTimestamp,
  ...rest
});
const rewriteBodyRes = ({
  rule_type_id: ruleTypeId,
  mute_all: muteAll,
  status_start_date: statusStartDate,
  status_end_date: statusEndDate,
  error_messages: errorMessages,
  last_run: lastRun,
  execution_duration: executionDuration,
  ...rest
}) => ({
  ...rest,
  ruleTypeId,
  muteAll,
  statusStartDate,
  statusEndDate,
  errorMessages,
  lastRun,
  executionDuration: executionDuration ? transformExecutionDuration(executionDuration) : undefined
});
async function loadRuleSummary({
  http,
  ruleId,
  numberOfExecutions
}) {
  const res = await http.get(`${_constants.INTERNAL_BASE_ALERTING_API_PATH}/rule/${encodeURIComponent(ruleId)}/_alert_summary`, {
    query: {
      number_of_executions: numberOfExecutions
    }
  });
  return rewriteBodyRes(res);
}