"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkRuleTypeEnabled = checkRuleTypeEnabled;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLicenseCheckResult = ruleType => {
  return {
    isEnabled: false,
    message: _i18n.i18n.translate('xpack.triggersActionsUI.checkRuleTypeEnabled.ruleTypeDisabledByLicenseMessage', {
      defaultMessage: 'This rule type requires a {minimumLicenseRequired} license.',
      values: {
        minimumLicenseRequired: (0, _lodash.upperFirst)(ruleType.minimumLicenseRequired)
      }
    })
  };
};
function checkRuleTypeEnabled(ruleType) {
  if ((ruleType === null || ruleType === void 0 ? void 0 : ruleType.enabledInLicense) === false) {
    return getLicenseCheckResult(ruleType);
  }
  return {
    isEnabled: true
  };
}