"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesSettingsQueryDelayTitle = exports.RulesSettingsQueryDelaySection = exports.RulesSettingsQueryDelayErrorPrompt = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/alerting-plugin/common");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _rule_settings_range_input = require("@kbn/alerts-ui-shared/src/rule_settings/rule_settings_range_input");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const queryDelayDescription = _i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.queryDelayDescription', {
  defaultMessage: 'Delay all rule queries to mitigate the impact of index refresh intervals on data availability.'
});
const queryDelayLabel = _i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.queryDelayLabel', {
  defaultMessage: 'Query delay length (seconds)'
});
const RulesSettingsQueryDelayErrorPrompt = exports.RulesSettingsQueryDelayErrorPrompt = /*#__PURE__*/(0, _react.memo)(() => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "rulesSettingsQueryDelayErrorPrompt",
    color: "danger",
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.rulesSettings.queryDelayErrorPromptTitle",
      defaultMessage: "Unable to load your query delay settings"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.rulesSettings.queryDelayErrorPromptBody",
      defaultMessage: "There was an error loading your query delay settings. Contact your administrator for help"
    }))
  });
});
const RulesSettingsQueryDelayTitle = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.rulesSettings.queryDelayTitle",
    defaultMessage: "Query delay"
  })));
};
exports.RulesSettingsQueryDelayTitle = RulesSettingsQueryDelayTitle;
const RulesSettingsQueryDelaySection = exports.RulesSettingsQueryDelaySection = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    onChange,
    settings,
    hasError,
    canShow,
    canWrite
  } = props;
  if (!canShow) {
    return null;
  }
  if (hasError) {
    return /*#__PURE__*/_react.default.createElement(RulesSettingsQueryDelayErrorPrompt, null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "rulesSettingsQueryDelaySection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(RulesSettingsQueryDelayTitle, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, queryDelayDescription))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_rule_settings_range_input.RuleSettingsRangeInput, {
    "data-test-subj": "queryDelayRangeInput",
    min: _common.MIN_QUERY_DELAY,
    max: _common.MAX_QUERY_DELAY,
    value: settings.delay,
    onChange: e => onChange('delay', parseInt(e.currentTarget.value, 10)),
    label: queryDelayLabel,
    disabled: !canWrite
  }))));
});