"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesSettingsFlappingSection = exports.RulesSettingsFlappingFormRight = exports.RulesSettingsFlappingFormLeft = exports.RulesSettingsFlappingErrorPrompt = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _rule_settings_flapping_message = require("@kbn/alerts-ui-shared/src/rule_settings/rule_settings_flapping_message");
var _rules_settings_flapping_form_section = require("./rules_settings_flapping_form_section");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const flappingDescription = _i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.flappingDetectionDescription', {
  defaultMessage: 'Detect alerts that switch quickly between active and recovered states and reduce unwanted noise for these flapping alerts.'
});
const flappingOnLabel = _i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.flappingOnLabel', {
  defaultMessage: 'On (recommended)'
});
const flappingOffLabel = _i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.flappingOffLabel', {
  defaultMessage: 'Off'
});
const RulesSettingsFlappingErrorPrompt = exports.RulesSettingsFlappingErrorPrompt = /*#__PURE__*/(0, _react.memo)(() => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "rulesSettingsFlappingErrorPrompt",
    color: "danger",
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.rulesSettings.flappingErrorPromptTitle",
      defaultMessage: "Unable to load your flapping settings"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.rulesSettings.flappingErrorPromptBody",
      defaultMessage: "There was an error loading your flapping settings. Contact your administrator for help"
    }))
  });
});
const RulesSettingsFlappingFormLeft = exports.RulesSettingsFlappingFormLeft = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    settings,
    onChange,
    isSwitchDisabled
  } = props;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, flappingDescription))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "rulesSettingsFlappingEnableSwitch",
    label: settings.enabled ? flappingOnLabel : flappingOffLabel,
    checked: settings.enabled,
    disabled: isSwitchDisabled,
    onChange: onChange
  }))));
});
const RulesSettingsFlappingFormRight = exports.RulesSettingsFlappingFormRight = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    settings,
    onChange,
    canWrite
  } = props;
  if (!settings) {
    return null;
  }
  if (!settings.enabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": "rulesSettingsFlappingOffPrompt"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      borderRadius: "none",
      color: "subdued",
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _rule_settings_flapping_message.flappingOffMessage)));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_rules_settings_flapping_form_section.RulesSettingsFlappingFormSection, {
    flappingSettings: settings,
    onChange: onChange,
    canWrite: canWrite
  }));
});
const RulesSettingsFlappingSection = exports.RulesSettingsFlappingSection = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    onChange,
    settings,
    hasError,
    canShow,
    canWrite
  } = props;
  if (!canShow) {
    return null;
  }
  if (hasError) {
    return /*#__PURE__*/_react.default.createElement(RulesSettingsFlappingErrorPrompt, null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "rulesSettingsFlappingSection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_rules_settings_flapping_form_section.RulesSettingsFlappingTitle, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(RulesSettingsFlappingFormLeft, {
    isSwitchDisabled: !canWrite,
    settings: settings,
    onChange: e => onChange('enabled', e.target.checked)
  }), /*#__PURE__*/_react.default.createElement(RulesSettingsFlappingFormRight, {
    settings: settings,
    onChange: (key, value) => onChange(key, value),
    canWrite: canWrite
  })));
});