"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoute = registerRoute;
var _common = require("../../api_schemas/common");
var _audit_messages = require("../../api_schemas/audit_messages");
var _constants = require("../../../../common/constants");
var _route_handler = require("./route_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerRoute({
  router,
  getLicense
}) {
  /**
   * @apiGroup Transforms Audit Messages
   *
   * @api {get} /internal/transform/transforms/:transformId/messages Transforms Messages
   * @apiName GetTransformsMessages
   * @apiDescription Get transforms audit messages
   *
   * @apiSchema (params) transformIdParamSchema
   */
  router.versioned.get({
    path: (0, _constants.addInternalBasePath)('transforms/{transformId}/messages'),
    access: 'internal'
  }).addVersion({
    version: '1',
    security: {
      authz: {
        enabled: false,
        reason: 'This route is opted out from authorization because permissions will be checked by elasticsearch'
      }
    },
    validate: {
      request: {
        params: _common.transformIdParamSchema,
        query: _audit_messages.getTransformAuditMessagesQuerySchema
      }
    }
  }, async (ctx, request, response) => {
    const license = await getLicense();
    return license.guardApiRoute(_route_handler.routeHandler)(ctx, request, response);
  });
}