"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Section = exports.ExpandedRowColumnView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Section = ({
  section
}) => {
  if (section.items.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("span", null, section.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    type: "column",
    listItems: section.items
  }));
};
exports.Section = Section;
const ExpandedRowColumnView = ({
  sections,
  showErrorCallout = false,
  dataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj !== null && dataTestSubj !== void 0 ? dataTestSubj : 'transformDetailsTabContent'
  }, showErrorCallout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.list.extendedStatsError",
    defaultMessage: "An error occurred fetching the extended stats for this transform. Basic stats are displayed instead."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: '50%'
    }
  }, sections.filter(s => s.position === 'left').map(s => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: s.title
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(Section, {
    section: s
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: '50%'
    }
  }, sections.filter(s => s.position === 'right').map(s => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: s.title
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(Section, {
    section: s
  }))))));
};
exports.ExpandedRowColumnView = ExpandedRowColumnView;