"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortTransformsToReauthorize = void 0;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// For transforms, some might be part of a integration package
// A transform might be dependent on the results of another transform
// If transforms have _meta.order specified, install sequentially (sort by package and install order)
const sortTransformsToReauthorize = transforms => {
  let shouldInstallSequentially = false;
  const mappedTransforms = transforms.map(t => {
    var _t$config;
    let packageName = '';
    let order = Number.MIN_VALUE;
    if ((0, _mlIsPopulatedObject.isPopulatedObject)(t === null || t === void 0 ? void 0 : (_t$config = t.config) === null || _t$config === void 0 ? void 0 : _t$config._meta, ['order'])) {
      if (typeof t.config._meta.order === 'number') {
        var _t$config2;
        shouldInstallSequentially = true;
        order = t === null || t === void 0 ? void 0 : (_t$config2 = t.config) === null || _t$config2 === void 0 ? void 0 : _t$config2._meta.order;
      }
      if ((0, _mlIsPopulatedObject.isPopulatedObject)(t.config._meta.package, ['name']) && typeof t.config._meta.package.name === 'string') {
        packageName = t.config._meta.package.name;
      }
    }
    return {
      id: t.id,
      order,
      packageName
    };
  });
  return {
    transformIds: shouldInstallSequentially ? (0, _lodash.sortBy)(mappedTransforms, ['packageName', 'order']).map(t => ({
      id: t.id
    })) : mappedTransforms.map(t => ({
      id: t.id
    })),
    shouldInstallSequentially
  };
};
exports.sortTransformsToReauthorize = sortTransformsToReauthorize;