"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUpdateValue = void 0;
var _lodash = require("lodash");
var _mlNestedProperty = require("@kbn/ml-nested-property");
var _value_parsers = require("./value_parsers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Takes a value from form state and applies it to the structure
// of the expected final configuration request object.
// Considers options like if a value is nullable or optional.
const getUpdateValue = (attribute, config, formFields, formSections, enforceFormValue = false) => {
  const formStateAttribute = formFields[attribute];
  const fallbackValue = formStateAttribute.isNullable ? null : formStateAttribute.defaultValue;
  const enabledBasedOnSection = formStateAttribute.section !== undefined ? formSections[formStateAttribute.section].enabled : true;
  const formValue = formStateAttribute.value !== '' ? _value_parsers.valueParsers[formStateAttribute.valueParser](formStateAttribute.value) : fallbackValue;
  const configValue = (0, _mlNestedProperty.getNestedProperty)(config, formStateAttribute.configFieldName, fallbackValue);

  // only get depending values if we're not already in a call to get depending values.
  const dependsOnConfig = enforceFormValue === false ? formStateAttribute.dependsOn.reduce((_dependsOnConfig, dependsOnField) => {
    return (0, _lodash.merge)({
      ..._dependsOnConfig
    }, getUpdateValue(dependsOnField, config, formFields, formSections, true));
  }, {}) : {};
  if (formValue === formStateAttribute.defaultValue && formValue === configValue && formStateAttribute.isOptional) {
    return {};
  }

  // If the resettable section the form field belongs to is disabled,
  // the whole section will be set to `null` to do the actual reset.
  if (formStateAttribute.section !== undefined && !enabledBasedOnSection) {
    return (0, _mlNestedProperty.setNestedProperty)(dependsOnConfig, formSections[formStateAttribute.section].configFieldName, null);
  }
  return enabledBasedOnSection && (formValue !== configValue || enforceFormValue) ? (0, _mlNestedProperty.setNestedProperty)(dependsOnConfig, formStateAttribute.configFieldName, formValue === '' && formStateAttribute.isOptional ? undefined : formValue) : {};
};
exports.getUpdateValue = getUpdateValue;