"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TermsAggForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TermsAggForm = ({
  aggConfig,
  onChange,
  isValid
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.agg.popoverForm.sizeLabel', {
      defaultMessage: 'Size'
    }),
    error: !isValid && [_i18n.i18n.translate('xpack.transform.groupBy.popoverForm.invalidSizeErrorMessage', {
      defaultMessage: 'Enter a valid positive number'
    })],
    isInvalid: !isValid
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: aggConfig.size,
    onChange: e => {
      onChange({
        size: Number(e.target.value)
      });
    }
  })));
};
exports.TermsAggForm = TermsAggForm;