"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceSearchBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../common/constants");
var _step_define = require("../step_define");
var _app_dependencies = require("../../../../app_dependencies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourceSearchBar = ({
  dataView,
  searchBar
}) => {
  const {
    actions: {
      searchChangeHandler,
      searchSubmitHandler,
      setQueryErrorMessage
    },
    state: {
      queryErrorMessage,
      searchInput
    }
  } = searchBar;
  const {
    unifiedSearch: {
      ui: {
        QueryStringInput
      }
    }
  } = (0, _app_dependencies.useAppDependencies)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInputPopover, {
    style: {
      maxWidth: '100%'
    },
    closePopover: () => setQueryErrorMessage(undefined),
    input: /*#__PURE__*/_react.default.createElement(QueryStringInput, {
      bubbleSubmitEvent: true,
      query: searchInput,
      indexPatterns: [dataView],
      onChange: searchChangeHandler,
      onSubmit: searchSubmitHandler,
      placeholder: searchInput.language === _step_define.QUERY_LANGUAGE_KUERY ? _i18n.i18n.translate('xpack.transform.stepDefineForm.queryPlaceholderKql', {
        defaultMessage: 'e.g. {example}',
        values: {
          example: 'method : "GET" or status : "404"'
        }
      }) : _i18n.i18n.translate('xpack.transform.stepDefineForm.queryPlaceholderLucene', {
        defaultMessage: 'e.g. {example}',
        values: {
          example: 'method:GET OR status:404'
        }
      }),
      disableAutoFocus: true,
      dataTestSubj: "transformQueryInput",
      languageSwitcherPopoverAnchorPosition: "rightDown",
      appName: _constants.PLUGIN.getI18nName()
    }),
    isOpen: (queryErrorMessage === null || queryErrorMessage === void 0 ? void 0 : queryErrorMessage.query) === searchInput.query && (queryErrorMessage === null || queryErrorMessage === void 0 ? void 0 : queryErrorMessage.message) !== ''
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, _i18n.i18n.translate('xpack.transform.stepDefineForm.invalidKuerySyntaxErrorMessageQueryBar', {
    defaultMessage: 'Invalid query: {queryErrorMessage}',
    values: {
      queryErrorMessage: queryErrorMessage === null || queryErrorMessage === void 0 ? void 0 : queryErrorMessage.message.split('\n')[0]
    }
  })));
};
exports.SourceSearchBar = SourceSearchBar;