"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupByLabelForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("../../../../common");
var _popover_form = require("./popover_form");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GroupByLabelForm = ({
  deleteHandler,
  item,
  otherAggNames,
  onChange,
  options
}) => {
  const [isPopoverVisible, setPopoverVisibility] = (0, _react.useState)(false);
  function update(updateItem) {
    onChange({
      ...updateItem
    });
    setPopoverVisibility(false);
  }
  let interval;
  if ((0, _common.isGroupByDateHistogram)(item)) {
    interval = item.calendar_interval;
  } else if ((0, _common.isGroupByHistogram)(item)) {
    interval = item.interval;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "transform__GroupByLabel--text"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textTruncate",
    "data-test-subj": "transformGroupByEntryLabel"
  }, item.aggName)), interval !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "transform__GroupByLabel--text transform__GroupByLabel--interval"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    className: "eui-textTruncate",
    "data-test-subj": "transformGroupByEntryIntervalLabel"
  }, interval)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "transform__GroupByLabel--button"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "transformIntervalFormPopover",
    ownFocus: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.transform.groupByLabelForm.editIntervalAriaLabel', {
        defaultMessage: 'Edit interval'
      }),
      size: "s",
      iconType: "pencil",
      onClick: () => setPopoverVisibility(!isPopoverVisible),
      "data-test-subj": "transformGroupByEntryEditButton"
    }),
    isOpen: isPopoverVisible,
    closePopover: () => setPopoverVisibility(false)
  }, /*#__PURE__*/_react.default.createElement(_popover_form.PopoverForm, {
    defaultData: item,
    onChange: update,
    otherAggNames: otherAggNames,
    options: options
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "transform__GroupByLabel--button"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.transform.groupByLabelForm.deleteItemAriaLabel', {
      defaultMessage: 'Delete item'
    }),
    size: "s",
    iconType: "cross",
    onClick: () => deleteHandler(item.aggName),
    "data-test-subj": "transformGroupByEntryDeleteButton"
  })));
};
exports.GroupByLabelForm = GroupByLabelForm;