"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDocumentationLinks = void 0;
var _app_dependencies = require("../app_dependencies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDocumentationLinks = () => {
  const deps = (0, _app_dependencies.useAppDependencies)();
  const {
    ELASTIC_WEBSITE_URL,
    DOC_LINK_VERSION
  } = deps.docLinks;
  return {
    esAggsCompositeMissingBucket: deps.docLinks.links.aggs.composite_missing_bucket,
    esIndicesCreateIndex: deps.docLinks.links.apis.createIndex,
    esNodeRoles: deps.docLinks.links.elasticsearch.nodeRoles,
    esPluginDocBasePath: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/plugins/${DOC_LINK_VERSION}/`,
    esQueryDsl: deps.docLinks.links.query.queryDsl,
    esTransform: deps.docLinks.links.transforms.guide,
    esTransformPivot: deps.docLinks.links.apis.createTransformRequest,
    esTransformUpdate: deps.docLinks.links.apis.updateTransform
  };
};
exports.useDocumentationLinks = useDocumentationLinks;