"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createApp = exports.ThreatIntelligencePlugin = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _reactRedux = require("react-redux");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _attachments = require("./modules/cases/utils/attachments");
var _use_kibana = require("./hooks/use_kibana");
var _security_solution_context = require("./containers/security_solution_context");
var _enterprise_guard = require("./containers/enterprise_guard");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LazyIndicatorsPageWrapper = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./containers/indicators_page_wrapper'))));

/**
 * This is used here:
 * x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/routes.tsx
 */
const createApp = services => () => ({
  securitySolutionContext
}) => /*#__PURE__*/_react.default.createElement(_i18nReact.__IntlProvider, null, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
  store: securitySolutionContext.securitySolutionStore
}, /*#__PURE__*/_react.default.createElement(_security_solution_context.SecuritySolutionContext.Provider, {
  value: securitySolutionContext
}, /*#__PURE__*/_react.default.createElement(_use_kibana.KibanaContextProvider, {
  services: services
}, /*#__PURE__*/_react.default.createElement(_enterprise_guard.EnterpriseGuard, null, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
  fallback: /*#__PURE__*/_react.default.createElement("div", null)
}, /*#__PURE__*/_react.default.createElement(LazyIndicatorsPageWrapper, null)))))));
exports.createApp = createApp;
class ThreatIntelligencePlugin {
  async setup(_core, plugins) {
    const externalAttachmentType = (0, _attachments.generateAttachmentType)();
    plugins.cases.attachmentFramework.registerExternalReference(externalAttachmentType);
    return {};
  }
  start(core, plugins) {
    const localPluginServices = {
      storage: new _public.Storage(localStorage)
    };
    const services = {
      ...localPluginServices,
      ...core,
      ...plugins
    };
    return {
      getComponent: createApp(services)
    };
  }
  stop() {}
}
exports.ThreatIntelligencePlugin = ThreatIntelligencePlugin;