"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldSchema = void 0;
var _public = require("@kbn/data-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns datagrid field schema for field type, the same implementation as in discover
 */
const getFieldSchema = kbnType => {
  // Default DataGrid schemas: boolean, numeric, datetime, json, currency, string
  switch (kbnType) {
    case _public.KBN_FIELD_TYPES.IP:
    case _public.KBN_FIELD_TYPES.GEO_SHAPE:
    case _public.KBN_FIELD_TYPES.NUMBER:
      return 'numeric';
    case _public.KBN_FIELD_TYPES.BOOLEAN:
      return 'boolean';
    case _public.KBN_FIELD_TYPES.STRING:
      return 'string';
    case _public.KBN_FIELD_TYPES.DATE:
      return 'datetime';
    default:
      return undefined;
  }
};
exports.getFieldSchema = getFieldSchema;