"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFetchIndicatorById = void 0;
var _search = require("../../../utils/search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createFetchIndicatorById = ({
  searchService,
  inspectorAdapter
}) => async ({
  indicatorId
}, signal) => {
  const query = {
    bool: {
      must: [{
        ids: {
          values: [indicatorId]
        }
      }]
    }
  };
  const fields = [{
    field: '*',
    include_unmapped: true
  }];
  const {
    hits: {
      hits: [firstResult]
    }
  } = await (0, _search.search)(searchService, {
    params: {
      body: {
        query,
        fields,
        size: 1
      }
    }
  }, {
    inspectorAdapter,
    requestName: `Fetch indicator by Id (${indicatorId})`,
    signal,
    skipDefaultStrategy: true
  });
  return firstResult;
};
exports.createFetchIndicatorById = createFetchIndicatorById;